/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owl2java.prefix;

import cz.cvut.kbss.jopa.owl2java.config.TransformationConfiguration;
import cz.cvut.kbss.jopa.owl2java.exception.OWL2JavaException;
import cz.cvut.kbss.jopa.owl2java.prefix.RemotePrefixResolver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixMap {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixMap.class);
    private final Map<String, String> prefixes;

    public PrefixMap(OWLOntologyManager ontologyManager, TransformationConfiguration config) {
        this.prefixes = PrefixMap.resolvePrefixes(Objects.requireNonNull(ontologyManager), config);
    }

    private static Map<String, String> resolvePrefixes(OWLOntologyManager ontologyManager, TransformationConfiguration config) {
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>(PrefixMap.builtInPrefixes());
        ((Stream)ontologyManager.ontologies().parallel()).filter(o -> o.getOntologyID().isNamed()).forEach(o -> {
            assert (o.getOntologyID().getOntologyIRI().isPresent());
            result.putAll(PrefixMap.resolveOntologyPrefixes(o, config.getOntologyPrefixProperty(), config.getRemotePrefixResolver()));
        });
        result.putAll(PrefixMap.resolvePrefixesFromPrefixMappingFile(config.getPrefixMappingFile()));
        LOG.debug("Resolved prefix map: {}", result);
        return result;
    }

    private static Map<String, String> resolveOntologyPrefixes(OWLOntology ontology, String prefixProperty, RemotePrefixResolver remotePrefixResolver) {
        HashMap<String, String> result = new HashMap<String, String>();
        OWLDataFactory df = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLAnnotationProperty annProperty = df.getOWLAnnotationProperty(prefixProperty);
        assert (ontology.getOntologyID().getOntologyIRI().isPresent());
        IRI ontologyIri = (IRI)ontology.getOntologyID().getOntologyIRI().get();
        ontology.axioms(AxiomType.ANNOTATION_ASSERTION).filter(ax -> ((OWLAnnotationProperty)ax.getProperty()).equals(annProperty) && ax.getValue().isLiteral() && ((OWLAnnotationSubject)ax.getSubject()).isIRI()).forEach(ax -> {
            assert (((OWLAnnotationSubject)ax.getSubject()).asIRI().isPresent());
            assert (ax.getValue().asLiteral().isPresent());
            result.put(((IRI)((OWLAnnotationSubject)ax.getSubject()).asIRI().get()).getIRIString(), ((OWLLiteral)ax.getValue().asLiteral().get()).getLiteral());
        });
        OWLDataProperty dataProperty = df.getOWLDataProperty(prefixProperty);
        ontology.axioms(AxiomType.DATA_PROPERTY_ASSERTION).filter(ax -> ((OWLDataPropertyExpression)ax.getProperty()).equals(dataProperty) && ax.getSubject().isIndividual()).forEach(ax -> result.put(ax.getSubject().asOWLNamedIndividual().toStringID(), ((OWLLiteral)ax.getObject()).getLiteral()));
        if (!result.containsKey(ontologyIri.getIRIString())) {
            remotePrefixResolver.resolvePrefix(ontologyIri).ifPresent(p -> result.put(ontologyIri.getIRIString(), (String)p));
        }
        return result;
    }

    private static Map<String, String> resolvePrefixesFromPrefixMappingFile(String mappingFilePath) {
        if (mappingFilePath == null) {
            return Collections.emptyMap();
        }
        File file = new File(mappingFilePath);
        try {
            LOG.debug("Loading prefix mapping from file '{}'.", (Object)file);
            List<String> lines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            HashMap<String, String> prefixMap = new HashMap<String, String>(lines.size());
            lines.stream().filter(line -> !line.isBlank()).forEach(line -> {
                String[] mapping = line.split("=");
                if (mapping.length != 2) {
                    LOG.warn("Mapping line '{}' does not correspond to the expected pattern '$namespace=$prefix'. Skipping it.", line);
                }
                prefixMap.put(mapping[0], mapping[1]);
            });
            return prefixMap;
        }
        catch (IOException e) {
            LOG.error("Unable to read prefix mapping file.", (Throwable)e);
            throw new OWL2JavaException("Unable to read prefix mapping file.", e);
        }
    }

    public Optional<String> getPrefix(IRI ontologyIri) {
        Objects.requireNonNull(ontologyIri);
        return Optional.ofNullable(this.prefixes.get(ontologyIri.getIRIString()));
    }

    public boolean hasPrefix(IRI ontologyIri) {
        Objects.requireNonNull(ontologyIri);
        return this.prefixes.containsKey(ontologyIri.getIRIString());
    }

    private static Map<String, String> builtInPrefixes() {
        return Map.of("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf", "http://www.w3.org/2000/01/rdf-schema#", "rdfs", "http://www.w3.org/2002/07/owl#", "owl", "http://www.w3.org/2004/02/skos/core#", "skos", "http://purl.org/dc/terms/", "dcterms");
    }
}

