/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.owlapi;

import cz.cvut.kbss.jopa.datatype.xsd.XsdTemporalMapper;
import cz.cvut.kbss.jopa.model.MultilingualString;
import cz.cvut.kbss.ontodriver.model.LangString;
import cz.cvut.kbss.ontodriver.model.Literal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;

public class DatatypeTransformer {
    private static final Map<OWL2Datatype, Class<?>> DATATYPE_MAP = new EnumMap(OWL2Datatype.class);
    private static final OWLDataFactory DATA_FACTORY = new OWLDataFactoryImpl();

    private DatatypeTransformer() {
        throw new AssertionError();
    }

    public static Class<?> transformOWLType(OWLDatatype dt) {
        Class<?> type = null;
        if (dt.isBuiltIn()) {
            type = DATATYPE_MAP.get(dt.getBuiltInDatatype());
        }
        if (type == null) {
            throw new IllegalArgumentException("Unsupported datatype: " + String.valueOf(dt));
        }
        return type;
    }

    public static OWLLiteral transform(Object value, String lang) {
        Objects.requireNonNull(value);
        if (value instanceof Integer) {
            return DATA_FACTORY.getOWLLiteral(value.toString(), OWL2Datatype.XSD_INT);
        }
        if (value instanceof BigInteger) {
            return DATA_FACTORY.getOWLLiteral(value.toString(), OWL2Datatype.XSD_INTEGER);
        }
        if (value instanceof Long) {
            return DATA_FACTORY.getOWLLiteral(value.toString(), OWL2Datatype.XSD_LONG);
        }
        if (value instanceof Short) {
            return DATA_FACTORY.getOWLLiteral(value.toString(), OWL2Datatype.XSD_SHORT);
        }
        if (value instanceof Byte) {
            return DATA_FACTORY.getOWLLiteral(value.toString(), OWL2Datatype.XSD_BYTE);
        }
        if (value instanceof Boolean) {
            return DATA_FACTORY.getOWLLiteral(((Boolean)value).booleanValue());
        }
        if (value instanceof Double) {
            return DATA_FACTORY.getOWLLiteral(((Double)value).doubleValue());
        }
        if (value instanceof Float) {
            return DATA_FACTORY.getOWLLiteral(((Float)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return DATA_FACTORY.getOWLLiteral(((BigDecimal)value).toPlainString(), OWL2Datatype.XSD_DECIMAL);
        }
        if (value instanceof LangString) {
            LangString ls = (LangString)value;
            return DATA_FACTORY.getOWLLiteral(ls.getValue(), (String)ls.getLanguage().orElse(null));
        }
        if (value instanceof String) {
            return lang != null ? DATA_FACTORY.getOWLLiteral(value.toString(), lang) : DATA_FACTORY.getOWLLiteral(value.toString());
        }
        if (value instanceof Date) {
            Literal ontoLiteral = XsdTemporalMapper.map((TemporalAccessor)((Date)value).toInstant());
            return DatatypeTransformer.toOwlLiteral(ontoLiteral);
        }
        if (value instanceof TemporalAccessor) {
            Literal ontoLiteral = XsdTemporalMapper.map((TemporalAccessor)((TemporalAccessor)value));
            return DatatypeTransformer.toOwlLiteral(ontoLiteral);
        }
        if (value instanceof TemporalAmount) {
            Literal ontoLiteral = XsdTemporalMapper.map((TemporalAmount)((TemporalAmount)value));
            return DatatypeTransformer.toOwlLiteral(ontoLiteral);
        }
        if (value.getClass().isEnum()) {
            return DATA_FACTORY.getOWLLiteral(value.toString());
        }
        if (value instanceof Literal) {
            return DatatypeTransformer.toOwlLiteral((Literal)value);
        }
        throw new IllegalArgumentException("Unsupported value " + String.valueOf(value) + " of type " + String.valueOf(value.getClass()));
    }

    private static OWLLiteral toOwlLiteral(Literal ontoLiteral) {
        return DATA_FACTORY.getOWLLiteral(ontoLiteral.getLexicalForm(), DATA_FACTORY.getOWLDatatype(ontoLiteral.getDatatype()));
    }

    static {
        DATATYPE_MAP.put(OWL2Datatype.RDF_PLAIN_LITERAL, String.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_STRING, String.class);
        DATATYPE_MAP.put(OWL2Datatype.RDF_XML_LITERAL, String.class);
        DATATYPE_MAP.put(OWL2Datatype.RDF_LANG_STRING, MultilingualString.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_INT, Integer.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_INTEGER, Integer.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_NON_NEGATIVE_INTEGER, Integer.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_POSITIVE_INTEGER, Integer.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_NON_POSITIVE_INTEGER, Integer.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_NEGATIVE_INTEGER, Integer.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_UNSIGNED_INT, Long.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_DOUBLE, Double.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_FLOAT, Float.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_BOOLEAN, Boolean.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_DATE_TIME, OffsetDateTime.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_DATE_TIME_STAMP, OffsetDateTime.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_SHORT, Short.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_UNSIGNED_SHORT, Integer.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_LONG, Long.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_UNSIGNED_LONG, BigInteger.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_BYTE, Byte.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_UNSIGNED_BYTE, Short.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_ANY_URI, URI.class);
        DATATYPE_MAP.put(OWL2Datatype.XSD_DECIMAL, BigDecimal.class);
    }
}

