/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.util;

import cz.cvut.kbss.jopa.owlapi.exception.MappingFileParserException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingFileParser {
    private static final Logger LOG = LoggerFactory.getLogger(MappingFileParser.class);
    public static final String DEFAULT_DELIMITER = ">";
    private static final String[] REMOTE_URL_SCHEMES = new String[]{"http://", "https://", "ftp://", "sftp://"};

    private MappingFileParser() {
        throw new AssertionError();
    }

    public static Map<URI, URI> getMappings(File mappingFile) {
        return MappingFileParser.getMappings(mappingFile, DEFAULT_DELIMITER);
    }

    public static Map<URI, URI> getMappings(File mappingFile, String delimiter) {
        Objects.requireNonNull(mappingFile);
        Objects.requireNonNull(delimiter);
        HashMap<URI, URI> map = new HashMap<URI, URI>();
        File defaultDir = mappingFile.getParentFile();
        try {
            List<String> lines = Files.readAllLines(mappingFile.toPath(), StandardCharsets.UTF_8);
            lines.forEach(line -> {
                StringTokenizer t = new StringTokenizer((String)line, delimiter);
                if (t.countTokens() != 2) {
                    LOG.warn("Ignoring line '{}' - invalid number of tokens = {}", line, (Object)t.countTokens());
                    return;
                }
                String uriName = t.nextToken().trim();
                String fileName = t.nextToken().trim();
                URI fileUri = MappingFileParser.resolveLocation(defaultDir, fileName);
                LOG.debug("Mapping ontology {} to location {}.", (Object)uriName, (Object)fileUri);
                map.put(URI.create(uriName), fileUri);
            });
        }
        catch (IOException e) {
            LOG.error("Unable to parse mapping file.", (Throwable)e);
            throw new MappingFileParserException(e);
        }
        return map;
    }

    private static URI resolveLocation(File defaultDir, String targetUri) {
        for (String scheme : REMOTE_URL_SCHEMES) {
            if (!targetUri.startsWith(scheme)) continue;
            try {
                return URI.create(targetUri);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Target URI {} looks like a remote URI, but is not valid.", (Object)targetUri);
                throw new MappingFileParserException(e);
            }
        }
        File actualFile = new File(targetUri).isAbsolute() ? new File(targetUri) : new File(defaultDir, targetUri);
        return actualFile.toURI();
    }
}

