/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.modelgen;

import cz.cvut.kbss.jopa.modelgen.OutputFilesGenerator;
import cz.cvut.kbss.jopa.modelgen.classmodel.Field;
import cz.cvut.kbss.jopa.modelgen.classmodel.MappingAnnotations;
import cz.cvut.kbss.jopa.modelgen.classmodel.MetamodelClass;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"cz.cvut.kbss.jopa.model.annotations.OWLClass", "cz.cvut.kbss.jopa.model.annotations.MappedSuperclass"})
@SupportedOptions(value={"outputDirectory", "sourcePackage", "debugOption"})
public class ModelGenProcessor
extends AbstractProcessor {
    public static final String OUTPUT_DIRECTORY_PARAM = "outputDirectory";
    public static final String SOURCE_PACKAGE_PARAM = "sourcePackage";
    public static final String DEBUG_PARAM = "debugOption";
    Messager messager;
    private Map<String, MetamodelClass> classes;
    private String sourcePackage;
    private String outputDirectory;
    private boolean debugOption;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.messager = env.getMessager();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Initializing ModelGenProcessor.");
        this.classes = new HashMap<String, MetamodelClass>();
        this.sourcePackage = env.getOptions().get(SOURCE_PACKAGE_PARAM);
        this.outputDirectory = env.getOptions().get(OUTPUT_DIRECTORY_PARAM);
        this.debugOption = Boolean.parseBoolean(env.getOptions().get(DEBUG_PARAM));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (this.isAnnotatedWithNonEntity(element) || this.sourcePackage != null && !element.asType().toString().contains(this.sourcePackage)) continue;
                MetamodelClass parentClass = new MetamodelClass(element);
                if (this.debugOption) {
                    this.messager.printMessage(Diagnostic.Kind.NOTE, "\t - Started processing class '" + parentClass.getName() + "'");
                }
                List<? extends Element> properties = element.getEnclosedElements();
                for (Element element2 : properties) {
                    if (!ModelGenProcessor.isPropertyPersistent(element2)) continue;
                    Field field = new Field(element2, element);
                    if (this.debugOption) {
                        this.messager.printMessage(Diagnostic.Kind.NOTE, "\t\t - Processing field '" + field.getName() + "'");
                    }
                    parentClass.addField(field);
                }
                this.classes.put(element.toString(), parentClass);
                if (!this.debugOption) continue;
                this.messager.printMessage(Diagnostic.Kind.NOTE, "\t - Finished processing class '" + parentClass.getName() + "'");
            }
        }
        if (this.debugOption) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Generating output files.");
        }
        OutputFilesGenerator outputGenerator = new OutputFilesGenerator(this.outputDirectory, this.debugOption, this.messager);
        outputGenerator.generateOutputFiles(this.classes.values());
        return true;
    }

    private static boolean isPropertyPersistent(Element param) {
        boolean containsWanted = false;
        List<? extends AnnotationMirror> paramAnnotations = param.getAnnotationMirrors();
        if (!paramAnnotations.isEmpty()) {
            block0: for (AnnotationMirror annotationMirror : paramAnnotations) {
                if (annotationMirror.toString().contains("cz.cvut.kbss.jopa.model.annotations.Transient")) {
                    return false;
                }
                for (MappingAnnotations anEnum : MappingAnnotations.values()) {
                    if (!annotationMirror.toString().contains(anEnum.getAnnotation())) continue;
                    containsWanted = true;
                    continue block0;
                }
            }
        }
        return containsWanted;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public boolean isAnnotatedWithNonEntity(Element element) {
        TypeElement typeElement = (TypeElement)element;
        List<? extends AnnotationMirror> annotations = typeElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!"cz.cvut.kbss.jopa.model.annotations.util.NonEntity".equals(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }
}

