/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.modelgen;

import cz.cvut.kbss.jopa.modelgen.classmodel.Field;
import cz.cvut.kbss.jopa.modelgen.classmodel.MappingAnnotations;
import cz.cvut.kbss.jopa.modelgen.classmodel.MetamodelClass;
import cz.cvut.kbss.jopa.modelgen.exception.ModelGenException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public class OutputFilesGenerator {
    private final String targetDir;
    private final boolean debugMode;
    private final Messager messager;

    public OutputFilesGenerator(String targetDir, boolean debugMode, Messager messager) {
        this.targetDir = targetDir;
        this.debugMode = debugMode;
        this.messager = messager;
    }

    public void generateOutputFiles(Collection<MetamodelClass> classes) {
        for (MetamodelClass cls : classes) {
            this.generateClassFile(cls);
        }
    }

    private void debug(String msg) {
        if (this.debugMode) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void generateClassFile(MetamodelClass cls) {
        File targetFile = this.createTargetFile(cls);
        StringBuilder content = new StringBuilder(this.generateClassPreamble(cls));
        content.append(OutputFilesGenerator.generateAttributes(cls));
        content.append(OutputFilesGenerator.generateClassSuffix());
        try {
            Files.writeString(targetFile.toPath(), (CharSequence)content.toString(), StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new ModelGenException("Unable to output content to target file '" + String.valueOf(targetFile) + "'!", e);
        }
        this.debug("\t - File '" + targetFile.getName() + "' created.");
    }

    private File createTargetFile(MetamodelClass cls) {
        StringBuilder fileName = new StringBuilder(this.targetDir);
        fileName.append("/");
        String pack = cls.getPckg();
        while (pack.contains(".")) {
            int index = pack.indexOf(".");
            fileName.append(pack, 0, index).append("/");
            pack = pack.substring(index + 1);
        }
        fileName.append(pack).append("/").append(cls.getName()).append("_.java");
        try {
            boolean result;
            File file = new File(fileName.toString());
            file.getParentFile().mkdirs();
            if (!file.exists() && !(result = file.createNewFile())) {
                throw new ModelGenException("Unable to create target file '" + String.valueOf(file) + "'!");
            }
            return file;
        }
        catch (IOException e) {
            throw new ModelGenException("Unable to create target file '" + String.valueOf(fileName) + "'!", e);
        }
    }

    public String generateClassPreamble(MetamodelClass cls) {
        Object extend = "";
        if (!cls.getExtend().isEmpty()) {
            extend = "extends ";
            extend = cls.getExtend().contains(".") ? (String)extend + cls.getExtend().substring(cls.getExtend().lastIndexOf(".") + 1) + "_ " : (String)extend + cls.getExtend();
        }
        StringBuilder sbOut = new StringBuilder();
        if (!cls.getPckg().isEmpty()) {
            sbOut.append("package ").append(cls.getPckg()).append(";\n\n");
        }
        cls.getImports().forEach(imp -> sbOut.append("import ").append((String)imp).append(";\n"));
        if (!cls.getExtend().isEmpty()) {
            sbOut.append("import ").append(cls.getExtend()).append("_;\n");
        }
        sbOut.append("\n@Generated(value = \"").append("cz.cvut.kbss.jopa.modelgen.ModelGenProcessor\")").append("\n@StaticMetamodel(").append(cls.getName()).append(".class)\n").append("public ").append("abstract ").append("class ").append(cls.getName()).append("_ ").append((String)extend).append("{\n\n");
        return sbOut.toString();
    }

    private static String generateAttributes(MetamodelClass cls) {
        StringBuilder attributes = new StringBuilder();
        for (Field field : cls.getFields()) {
            String declaringClass = field.getParentName().substring(field.getParentName().lastIndexOf(46) + 1);
            attributes.append("    public static volatile ");
            if (OutputFilesGenerator.isAnnotatedWith(field, MappingAnnotations.ID)) {
                attributes.append("Identifier<").append(declaringClass).append(", ").append(field.getType().getTypeName().substring(field.getType().getTypeName().lastIndexOf(".") + 1));
            } else if (OutputFilesGenerator.isAnnotatedWith(field, MappingAnnotations.TYPES)) {
                attributes.append("TypesSpecification<").append(declaringClass).append(", ");
                if (field.getType().getIsSimple().booleanValue()) {
                    attributes.append(field.getType().getSimpleName());
                } else {
                    attributes.append(field.getType().getTypes().get(0).getSimpleName());
                }
            } else if (OutputFilesGenerator.isAnnotatedWith(field, MappingAnnotations.PROPERTIES)) {
                attributes.append("PropertiesSpecification<").append(declaringClass).append(", ");
                type = field.getType();
                if (!Objects.equals(type.getTypeName(), Map.class.getName())) {
                    attributes.append(type.getTypes().get(0).getTypeName().substring(type.getTypes().get(0).getTypeName().lastIndexOf(".") + 1));
                } else {
                    attributes.append("Map, ").append(type.getTypes().get(0).getSimpleName()).append(", ").append(type.getTypes().get(1).getTypes().get(0).getSimpleName());
                }
            } else if (OutputFilesGenerator.isAnnotatedWith(field, MappingAnnotations.DATA_PROPERTY) || OutputFilesGenerator.isAnnotatedWith(field, MappingAnnotations.OBJECT_PROPERTY) || OutputFilesGenerator.isAnnotatedWith(field, MappingAnnotations.ANNOTATION_PROPERTY)) {
                type = field.getType();
                if (type.getIsSimple().booleanValue()) {
                    attributes.append("SingularAttribute<").append(declaringClass).append(", ").append(type.getSimpleName());
                } else {
                    if (type.getTypeName().equals(List.class.getName())) {
                        attributes.append("ListAttribute<");
                    } else if (type.getTypeName().equals(Set.class.getName())) {
                        attributes.append("SetAttribute<");
                    }
                    attributes.append(declaringClass).append(", ").append(type.getTypes().get(0).getSimpleName());
                }
            }
            attributes.append("> ").append(field.getName()).append(";\n");
        }
        return attributes.toString();
    }

    private static String generateClassSuffix() {
        return "}";
    }

    static boolean isAnnotatedWith(Field field, MappingAnnotations mappingAnnotations) {
        List<MappingAnnotations> annotations = field.getAnnotatedWith();
        if (annotations.isEmpty()) {
            return false;
        }
        for (MappingAnnotations an : annotations) {
            if (!an.equals((Object)mappingAnnotations)) continue;
            return true;
        }
        return false;
    }
}

