/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.jopa.modelgen.classmodel;

import cz.cvut.kbss.jopa.modelgen.exception.ModelGenException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class Type {
    private String typeName;
    private String simpleName;
    private Boolean isSimple;
    private List<Type> types;

    public Type() {
        this.typeName = "";
        this.isSimple = true;
        this.types = new ArrayList<Type>();
    }

    public Type(TypeMirror tMirror) {
        if (tMirror.getKind() != TypeKind.DECLARED && tMirror.getKind() != TypeKind.TYPEVAR) {
            throw new ModelGenException("Only declared types and type variables are supported, got " + String.valueOf(tMirror) + " of type " + String.valueOf((Object)tMirror.getKind()));
        }
        if (Type.isSimple(tMirror)) {
            this.isSimple = true;
            DeclaredType declaredType = (DeclaredType)Type.getUpperBound(tMirror);
            this.typeName = declaredType.asElement().toString();
            this.simpleName = declaredType.asElement().getSimpleName().toString();
        } else {
            assert (tMirror instanceof DeclaredType);
            DeclaredType declaredType = (DeclaredType)tMirror;
            List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
            this.typeName = declaredType.asElement().toString();
            this.simpleName = declaredType.asElement().getSimpleName().toString();
            this.isSimple = false;
            this.types = typeArgs.stream().map(Type::new).toList();
        }
    }

    private static TypeMirror getUpperBound(TypeMirror type) {
        if (type instanceof TypeVariable) {
            return ((TypeVariable)type).getUpperBound();
        }
        return type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public Boolean getIsSimple() {
        return this.isSimple;
    }

    public void setIsSimple(Boolean isSimple) {
        this.isSimple = isSimple;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public void setTypes(List<Type> types) {
        this.types = types;
    }

    private static boolean isSimple(TypeMirror typeMirror) {
        String typeName;
        if (typeMirror instanceof DeclaredType) {
            DeclaredType dt = (DeclaredType)typeMirror;
            typeName = dt.asElement().toString();
        } else if (typeMirror instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)typeMirror;
            typeName = tv.asElement().toString();
        } else {
            typeName = typeMirror.toString();
        }
        return !typeName.contains(Set.class.getName()) && !typeName.contains(List.class.getName()) && !typeName.contains(Collection.class.getName()) && !typeName.contains(Map.class.getName());
    }
}

