/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public class OntologyStorageProperties {
    private final URI ontologyUri;
    private final URI physicalUri;
    private final String driver;
    private final String username;
    private final String password;

    private OntologyStorageProperties(OntologyStoragePropertiesBuilder builder) {
        this.physicalUri = Objects.requireNonNull(builder.physicalUri, "Ontology physical URI is required!");
        this.driver = Objects.requireNonNull(builder.driverClass, "OntDriver data source class name is required!");
        this.ontologyUri = builder.ontologyUri;
        this.username = builder.username;
        this.password = builder.password;
    }

    public Optional<URI> getOntologyURI() {
        return Optional.ofNullable(this.ontologyUri);
    }

    public URI getPhysicalURI() {
        return this.physicalUri;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StorageProperties: logical URI = ");
        b.append(this.ontologyUri);
        b.append(", physical URI = ");
        b.append(this.physicalUri);
        b.append(", data source class = ");
        b.append(this.driver);
        if (this.username != null) {
            b.append(", username = ");
            b.append(this.username);
            b.append(", password = ");
            b.append(this.password);
        }
        return b.toString();
    }

    public static OntologyStoragePropertiesBuilder ontologyUri(URI ontologyUri) {
        return new OntologyStoragePropertiesBuilder().ontologyUri(ontologyUri);
    }

    public static OntologyStoragePropertiesBuilder physicalUri(URI physicalUri) {
        return new OntologyStoragePropertiesBuilder().physicalUri(physicalUri);
    }

    public static OntologyStoragePropertiesBuilder username(String username) {
        return new OntologyStoragePropertiesBuilder().username(username);
    }

    public static OntologyStoragePropertiesBuilder password(String password) {
        return new OntologyStoragePropertiesBuilder().password(password);
    }

    public static OntologyStoragePropertiesBuilder driver(String driverClass) {
        return new OntologyStoragePropertiesBuilder().driver(driverClass);
    }

    public static class OntologyStoragePropertiesBuilder {
        private URI ontologyUri;
        private URI physicalUri;
        private String username;
        private String password;
        private String driverClass;

        public OntologyStoragePropertiesBuilder ontologyUri(URI ontologyUri) {
            this.ontologyUri = ontologyUri;
            return this;
        }

        public OntologyStoragePropertiesBuilder ontologyUri(String ontologyUri) {
            this.ontologyUri = ontologyUri != null ? URI.create(ontologyUri) : null;
            return this;
        }

        public OntologyStoragePropertiesBuilder physicalUri(URI physicalUri) {
            this.physicalUri = physicalUri;
            return this;
        }

        public OntologyStoragePropertiesBuilder physicalUri(String physicalUri) {
            this.physicalUri = physicalUri != null ? URI.create(physicalUri) : null;
            return this;
        }

        public OntologyStoragePropertiesBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OntologyStoragePropertiesBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OntologyStoragePropertiesBuilder driver(String driverClass) {
            this.driverClass = driverClass;
            return this;
        }

        public OntologyStorageProperties build() {
            return new OntologyStorageProperties(this);
        }
    }
}

