/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.config;

import cz.cvut.kbss.ontodriver.OntologyStorageProperties;
import cz.cvut.kbss.ontodriver.config.ConfigurationParameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class DriverConfiguration {
    private final Map<ConfigurationParameter, String> configuration = new HashMap<ConfigurationParameter, String>();
    private final OntologyStorageProperties storageProperties;

    public DriverConfiguration(OntologyStorageProperties storageProperties) {
        this.storageProperties = Objects.requireNonNull(storageProperties);
    }

    public void addConfiguration(Map<String, String> properties, Collection<ConfigurationParameter> parameters) {
        Objects.requireNonNull(properties);
        Objects.requireNonNull(parameters);
        parameters.stream().filter(p -> properties.containsKey(p.toString())).forEach(p -> this.setProperty((ConfigurationParameter)p, (String)properties.get(p.toString())));
    }

    public void setProperty(ConfigurationParameter property, String value) {
        Objects.requireNonNull(property);
        this.configuration.put(property, value);
    }

    public String getProperty(ConfigurationParameter property) {
        Objects.requireNonNull(property);
        return this.configuration.get(property);
    }

    public String getProperty(ConfigurationParameter property, String defaultValue) {
        Objects.requireNonNull(property);
        return this.configuration.getOrDefault(property, defaultValue);
    }

    public int getProperty(ConfigurationParameter property, int defaultValue) {
        String propertyValue = this.getProperty(property, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value '" + propertyValue + "' of property '" + propertyValue + "' is not a valid integer.", e);
        }
    }

    public boolean is(ConfigurationParameter property) {
        Objects.requireNonNull(property);
        return Boolean.parseBoolean(this.configuration.get(property));
    }

    public boolean isSet(ConfigurationParameter property) {
        return this.configuration.containsKey(property);
    }

    public OntologyStorageProperties getStorageProperties() {
        return this.storageProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DriverConfiguration that = (DriverConfiguration)o;
        return this.configuration.equals(that.configuration) && this.storageProperties.equals(that.storageProperties);
    }

    public int hashCode() {
        int result = this.configuration.hashCode();
        result = 31 * result + this.storageProperties.hashCode();
        return result;
    }
}

