/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.descriptor;

import cz.cvut.kbss.ontodriver.descriptor.AbstractAxiomDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AxiomDescriptor
extends AbstractAxiomDescriptor {
    private final Set<URI> subjectContexts = new HashSet<URI>(4);
    private final Map<Assertion, Set<URI>> assertionContexts = new HashMap<Assertion, Set<URI>>();

    public AxiomDescriptor(NamedResource subject) {
        super(subject);
    }

    public AxiomDescriptor addSubjectContext(URI context) {
        if (context == null) {
            this.subjectContexts.clear();
        } else {
            this.subjectContexts.add(context);
        }
        return this;
    }

    public void addAssertion(Assertion assertion) {
        Objects.requireNonNull(assertion);
        this.assertionContexts.put(assertion, null);
    }

    public AxiomDescriptor addAssertionContext(Assertion assertion, URI context) {
        Objects.requireNonNull(assertion);
        if (!this.assertionContexts.containsKey(assertion)) {
            throw new IllegalArgumentException("Assertion " + String.valueOf(assertion) + " is not present in this descriptor.");
        }
        Set contexts = this.assertionContexts.computeIfAbsent(assertion, a -> new HashSet());
        if (context == null) {
            contexts.clear();
        } else {
            contexts.add(context);
        }
        return this;
    }

    @Override
    public Set<Assertion> getAssertions() {
        return Collections.unmodifiableSet(this.assertionContexts.keySet());
    }

    @Override
    public boolean containsAssertion(Assertion assertion) {
        return this.assertionContexts.containsKey(assertion);
    }

    @Override
    public Set<URI> getSubjectContexts() {
        return Collections.unmodifiableSet(this.subjectContexts);
    }

    @Override
    public Set<URI> getAssertionContexts(Assertion assertion) {
        Objects.requireNonNull(assertion);
        if (!this.assertionContexts.containsKey(assertion) || this.assertionContexts.get(assertion) == null) {
            return this.getSubjectContexts();
        }
        return Collections.unmodifiableSet(this.assertionContexts.get(assertion));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AxiomDescriptor)) {
            return false;
        }
        AxiomDescriptor that = (AxiomDescriptor)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.subjectContexts.equals(that.subjectContexts) && this.assertionContexts.equals(that.assertionContexts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subjectContexts, this.assertionContexts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getSubject());
        sb.append(" - ").append(this.subjectContexts);
        if (!this.assertionContexts.isEmpty()) {
            sb.append(", properties: ").append(this.assertionContexts);
        }
        sb.append("]");
        return sb.toString();
    }
}

