/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.descriptor;

import cz.cvut.kbss.ontodriver.descriptor.AbstractAxiomDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AxiomValueDescriptor
extends AbstractAxiomDescriptor {
    private URI subjectContext;
    private final Map<Assertion, AssertionData> assertionData = new HashMap<Assertion, AssertionData>();

    public AxiomValueDescriptor(NamedResource subject) {
        super(subject);
    }

    public void setSubjectContext(URI context) {
        this.subjectContext = context;
    }

    public URI getSubjectContext() {
        return this.subjectContext;
    }

    public void addAssertion(Assertion assertion) {
        Objects.requireNonNull(assertion);
        this.assertionData.put(assertion, new AssertionData());
    }

    @Override
    public Set<Assertion> getAssertions() {
        return Collections.unmodifiableSet(this.assertionData.keySet());
    }

    @Override
    public boolean containsAssertion(Assertion assertion) {
        return this.assertionData.containsKey(assertion);
    }

    @Override
    public Set<URI> getSubjectContexts() {
        return this.subjectContext != null ? Collections.singleton(this.getSubjectContext()) : Collections.emptySet();
    }

    @Override
    public Set<URI> getAssertionContexts(Assertion assertion) {
        URI ctx = this.getAssertionContext(assertion);
        return ctx != null ? Collections.singleton(ctx) : Collections.emptySet();
    }

    public URI getAssertionContext(Assertion assertion) {
        Objects.requireNonNull(assertion);
        if (!this.assertionData.containsKey(assertion) || !this.assertionData.get((Object)assertion).hasContext) {
            return this.subjectContext;
        }
        return this.assertionData.get((Object)assertion).context;
    }

    public void setAssertionContext(Assertion assertion, URI context) {
        Objects.requireNonNull(assertion);
        if (!this.assertionData.containsKey(assertion)) {
            throw new IllegalArgumentException("Assertion " + String.valueOf(assertion) + " is not present in this descriptor.");
        }
        this.assertionData.get(assertion).setContext(context);
    }

    public AxiomValueDescriptor addAssertionValue(Assertion assertion, Value<?> value) {
        Objects.requireNonNull(assertion);
        Objects.requireNonNull(value);
        List<Value<?>> assertionValues = this.getAssertionList(assertion);
        assertionValues.add(value);
        return this;
    }

    public List<Value<?>> getAssertionValues(Assertion assertion) {
        Objects.requireNonNull(assertion);
        if (!this.assertionData.containsKey(assertion)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.assertionData.get((Object)assertion).values);
    }

    private List<Value<?>> getAssertionList(Assertion assertion) {
        assert (assertion != null);
        if (!this.assertionData.containsKey(assertion)) {
            this.addAssertion(assertion);
        }
        return this.assertionData.get((Object)assertion).values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AxiomValueDescriptor)) {
            return false;
        }
        AxiomValueDescriptor that = (AxiomValueDescriptor)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.subjectContext, that.subjectContext) && this.assertionData.equals(that.assertionData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.subjectContext, this.assertionData);
    }

    public String toString() {
        return "AxiomValueDescriptor{<" + String.valueOf(this.getSubject()) + "> - " + String.valueOf(this.assertionData) + "}";
    }

    private static class AssertionData {
        private final List<Value<?>> values = new ArrayList();
        private URI context;
        private boolean hasContext;

        private AssertionData() {
        }

        private void setContext(URI context) {
            this.context = context;
            this.hasContext = true;
        }

        public String toString() {
            return "AssertionData{values=" + String.valueOf(this.values) + "}";
        }
    }
}

