/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.descriptor;

import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import java.net.URI;
import java.util.Objects;

public class ContainerDescriptor {
    private final Type type;
    private final NamedResource owner;
    private final Assertion property;
    private final URI context;

    protected ContainerDescriptor(Type type, NamedResource owner, Assertion property, URI context) {
        this.type = type;
        this.owner = owner;
        this.property = property;
        this.context = context;
    }

    public URI getType() {
        return this.type.uri;
    }

    public NamedResource getOwner() {
        return this.owner;
    }

    public Assertion getProperty() {
        return this.property;
    }

    public URI getContext() {
        return this.context;
    }

    public static ContainerDescriptor altDescriptor(NamedResource owner, Assertion property) {
        return new ContainerDescriptor(Type.ALT, owner, property, null);
    }

    public static ContainerDescriptor altDescriptor(NamedResource owner, Assertion property, URI context) {
        return new ContainerDescriptor(Type.ALT, owner, property, context);
    }

    public static ContainerDescriptor bagDescriptor(NamedResource owner, Assertion property) {
        return new ContainerDescriptor(Type.BAG, owner, property, null);
    }

    public static ContainerDescriptor bagDescriptor(NamedResource owner, Assertion property, URI context) {
        return new ContainerDescriptor(Type.BAG, owner, property, context);
    }

    public static ContainerDescriptor seqDescriptor(NamedResource owner, Assertion property) {
        return new ContainerDescriptor(Type.SEQ, owner, property, null);
    }

    public static ContainerDescriptor seqDescriptor(NamedResource owner, Assertion property, URI context) {
        return new ContainerDescriptor(Type.SEQ, owner, property, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerDescriptor)) {
            return false;
        }
        ContainerDescriptor that = (ContainerDescriptor)o;
        return this.type == that.type && Objects.equals(this.getOwner(), that.getOwner()) && Objects.equals(this.getProperty(), that.getProperty()) && Objects.equals(this.getContext(), that.getContext());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.getOwner(), this.getProperty(), this.getContext()});
    }

    protected static enum Type {
        ALT(URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt")),
        BAG(URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag")),
        SEQ(URI.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq"));

        private final URI uri;

        private Type(URI uri) {
            this.uri = uri;
        }
    }
}

