/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.descriptor;

import cz.cvut.kbss.ontodriver.descriptor.ContainerDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ContainerValueDescriptor<T>
extends ContainerDescriptor {
    private final List<T> values = new ArrayList<T>();

    private ContainerValueDescriptor(ContainerDescriptor.Type type, NamedResource owner, Assertion property, URI context) {
        super(type, owner, property, context);
    }

    public List<T> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(T value) {
        this.values.add(Objects.requireNonNull(value));
    }

    public static <T> ContainerValueDescriptor<T> altValueDescriptor(NamedResource owner, Assertion property) {
        return new ContainerValueDescriptor<T>(ContainerDescriptor.Type.ALT, owner, property, null);
    }

    public static <T> ContainerValueDescriptor<T> altValueDescriptor(NamedResource owner, Assertion property, URI context) {
        return new ContainerValueDescriptor<T>(ContainerDescriptor.Type.ALT, owner, property, context);
    }

    public static <T> ContainerValueDescriptor<T> bagValueDescriptor(NamedResource owner, Assertion property) {
        return new ContainerValueDescriptor<T>(ContainerDescriptor.Type.BAG, owner, property, null);
    }

    public static <T> ContainerValueDescriptor<T> bagValueDescriptor(NamedResource owner, Assertion property, URI context) {
        return new ContainerValueDescriptor<T>(ContainerDescriptor.Type.BAG, owner, property, context);
    }

    public static <T> ContainerValueDescriptor<T> seqValueDescriptor(NamedResource owner, Assertion property) {
        return new ContainerValueDescriptor<T>(ContainerDescriptor.Type.SEQ, owner, property, null);
    }

    public static <T> ContainerValueDescriptor<T> seqValueDescriptor(NamedResource owner, Assertion property, URI context) {
        return new ContainerValueDescriptor<T>(ContainerDescriptor.Type.SEQ, owner, property, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerValueDescriptor)) {
            return false;
        }
        ContainerValueDescriptor that = (ContainerValueDescriptor)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.getValues(), that.getValues());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValues());
    }
}

