/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.model;

import cz.cvut.kbss.ontodriver.model.AnnotationPropertyAssertion;
import cz.cvut.kbss.ontodriver.model.ClassAssertion;
import cz.cvut.kbss.ontodriver.model.DataPropertyAssertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.ObjectPropertyAssertion;
import cz.cvut.kbss.ontodriver.model.PropertyAssertion;
import java.net.URI;
import java.util.Objects;

public abstract class Assertion
extends NamedResource {
    protected final String language;
    private final boolean hasLanguage;
    private final boolean inferred;

    protected Assertion(URI identifier, boolean isInferred) {
        super(identifier);
        this.inferred = isInferred;
        this.language = null;
        this.hasLanguage = false;
    }

    protected Assertion(URI identifier, String language, boolean isInferred) {
        super(identifier);
        this.inferred = isInferred;
        this.language = language;
        this.hasLanguage = language != null;
    }

    public boolean isInferred() {
        return this.inferred;
    }

    public boolean isClassAssertion() {
        return this.getIdentifier().equals(ClassAssertion.RDF_TYPE);
    }

    public abstract AssertionType getType();

    public String getLanguage() {
        return this.language;
    }

    public boolean hasLanguage() {
        return this.hasLanguage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Assertion)) {
            return false;
        }
        Assertion assertion = (Assertion)o;
        if (!super.equals(o)) {
            return false;
        }
        return this.inferred == assertion.inferred && Objects.equals(this.language, assertion.language);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.language, this.inferred);
    }

    @Override
    public String toString() {
        return super.toString() + (this.inferred ? " - inferred" : " - non-inferred");
    }

    public static Assertion createClassAssertion(boolean isInferred) {
        return new ClassAssertion(isInferred);
    }

    public static Assertion createUnspecifiedPropertyAssertion(boolean isInferred) {
        return new PropertyAssertion(isInferred);
    }

    public static Assertion createUnspecifiedPropertyAssertion(String language, boolean isInferred) {
        return new PropertyAssertion(language, isInferred);
    }

    public static Assertion createPropertyAssertion(URI assertionIdentifier, boolean isInferred) {
        return new PropertyAssertion(assertionIdentifier, isInferred);
    }

    public static Assertion createPropertyAssertion(URI assertionIdentifier, String language, boolean isInferred) {
        return new PropertyAssertion(assertionIdentifier, language, isInferred);
    }

    public static Assertion createObjectPropertyAssertion(URI assertionIdentifier, boolean isInferred) {
        return new ObjectPropertyAssertion(assertionIdentifier, isInferred);
    }

    public static Assertion createDataPropertyAssertion(URI assertionIdentifier, boolean isInferred) {
        return new DataPropertyAssertion(assertionIdentifier, isInferred);
    }

    public static Assertion createDataPropertyAssertion(URI assertionIdentifier, String language, boolean isInferred) {
        return new DataPropertyAssertion(assertionIdentifier, language, isInferred);
    }

    public static Assertion createAnnotationPropertyAssertion(URI assertionIdentifier, boolean isInferred) {
        return new AnnotationPropertyAssertion(assertionIdentifier, isInferred);
    }

    public static Assertion createAnnotationPropertyAssertion(URI assertionIdentifier, String language, boolean isInferred) {
        return new AnnotationPropertyAssertion(assertionIdentifier, language, isInferred);
    }

    public static enum AssertionType {
        CLASS,
        PROPERTY,
        OBJECT_PROPERTY,
        DATA_PROPERTY,
        ANNOTATION_PROPERTY;

    }
}

