/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.model;

import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import java.util.Objects;

public final class AxiomImpl<T>
implements Axiom<T> {
    private final NamedResource subject;
    private final Assertion assertion;
    private final Value<T> value;

    public AxiomImpl(NamedResource subject, Assertion assertion, Value<T> value) {
        this.subject = Objects.requireNonNull(subject);
        this.assertion = Objects.requireNonNull(assertion);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public NamedResource getSubject() {
        return this.subject;
    }

    @Override
    public Assertion getAssertion() {
        return this.assertion;
    }

    @Override
    public Value<T> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxiomImpl axiom = (AxiomImpl)o;
        return this.subject.equals(axiom.subject) && this.assertion.equals(axiom.assertion) && this.value.equals(axiom.value);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.assertion, this.value);
    }

    public String toString() {
        return "[" + String.valueOf(this.subject) + " " + String.valueOf(this.assertion) + " " + String.valueOf(this.value) + "]";
    }
}

