/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.model;

import java.util.Objects;

public class Value<T> {
    private static final Value<?> NULL_VALUE = new NullValue();
    private final T value;

    private Value() {
        this.value = null;
    }

    public Value(T value) {
        Objects.requireNonNull(value);
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public String stringValue() {
        return this.value != null ? this.value.toString() : null;
    }

    public static <T> Value<T> nullValue() {
        return NULL_VALUE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "";
    }

    private static final class NullValue
    extends Value<Void> {
        private NullValue() {
        }

        @Override
        public String stringValue() {
            return "null";
        }
    }
}

