/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.util;

import cz.cvut.kbss.ontodriver.model.NamedResource;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.Random;
import java.util.Set;

public class IdentifierUtils {
    public static final Set<Class<?>> IDENTIFIER_TYPES = Set.of(NamedResource.class, URI.class, URL.class);
    private static final Random RANDOM = new Random();

    private IdentifierUtils() {
        throw new AssertionError();
    }

    public static URI generateIdentifier(URI classUri) {
        Objects.requireNonNull(classUri);
        if (classUri.getFragment() != null) {
            return URI.create(String.valueOf(classUri) + "_instance" + RANDOM.nextInt());
        }
        String base = classUri.toString();
        if (base.endsWith("/")) {
            return URI.create(base + "instance" + RANDOM.nextInt());
        }
        return URI.create(base + "/instance" + RANDOM.nextInt());
    }

    public static int randomInt() {
        return RANDOM.nextInt();
    }

    public static boolean isResourceIdentifierType(Class<?> cls) {
        return IDENTIFIER_TYPES.contains(cls);
    }
}

