/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StatementHolder {
    private Map<String, String> paramValues;
    private List<String> paramNames;
    private List<String> statementParts;
    private final String statement;

    public StatementHolder(String statement) {
        Objects.requireNonNull(statement);
        this.statement = statement.trim();
    }

    public void analyzeStatement() {
        this.paramNames = new ArrayList<String>();
        this.statementParts = new ArrayList<String>();
        boolean inSQString = false;
        boolean inDQString = false;
        boolean inParam = false;
        int lastParamEndIndex = 0;
        int paramStartIndex = 0;
        block6: for (int i = 0; i < this.statement.length(); ++i) {
            char c = this.statement.charAt(i);
            switch (c) {
                case '\'': {
                    inSQString = !inSQString;
                    continue block6;
                }
                case '\"': {
                    inDQString = !inDQString;
                    continue block6;
                }
                case '?': {
                    if (inSQString || inDQString) continue block6;
                    this.statementParts.add(this.statement.substring(lastParamEndIndex, i));
                    paramStartIndex = i + 1;
                    inParam = true;
                    continue block6;
                }
                case '\n': 
                case ' ': 
                case ')': 
                case ',': 
                case '.': 
                case ';': 
                case '<': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (!inParam) continue block6;
                    lastParamEndIndex = i;
                    String param = this.statement.substring(paramStartIndex, i);
                    this.paramNames.add(param);
                    inParam = false;
                    continue block6;
                }
            }
        }
        this.statementParts.add(this.statement.substring(lastParamEndIndex));
        this.paramValues = new HashMap<String, String>(this.paramNames.size());
        assert (this.statementParts.size() == this.paramNames.size() + 1);
    }

    public void setParameter(String parameterName, String value) {
        this.ensureState();
        if (!this.paramNames.contains(parameterName)) {
            throw new IllegalArgumentException("Unknown binding name " + parameterName);
        }
        this.paramValues.put(parameterName, value);
    }

    private void ensureState() {
        if (this.paramNames == null) {
            throw new IllegalStateException("Statement has to be analyzed before working with parameters.");
        }
    }

    public String assembleStatement() {
        if (this.isNotParametrized()) {
            return this.statement;
        }
        StringBuilder sb = new StringBuilder(this.statement.length());
        for (int i = 0; i < this.paramNames.size(); ++i) {
            sb.append(this.statementParts.get(i));
            String paramValue = this.paramValues.get(this.paramNames.get(i));
            if (paramValue == null) {
                sb.append("?").append(this.paramNames.get(i));
                continue;
            }
            sb.append(paramValue);
        }
        sb.append(this.statementParts.get(this.paramNames.size()));
        return sb.toString();
    }

    public String getStatement() {
        return this.statement;
    }

    private boolean isNotParametrized() {
        return this.paramNames == null || this.paramNames.isEmpty();
    }

    public void clearParameters() {
        this.ensureState();
        this.paramValues.replaceAll((p, v) -> null);
    }
}

