/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.util;

import cz.cvut.kbss.ontodriver.util.TransactionState;

public final class Transaction {
    private TransactionState state;

    public void begin() {
        if (this.state != null && this.state != TransactionState.ABORTED && this.state != TransactionState.COMMITTED) {
            throw new IllegalStateException("Cannot begin transaction. Current state is " + String.valueOf((Object)this.state));
        }
        this.state = TransactionState.ACTIVE;
    }

    public void commit() {
        this.verifyActive();
        this.state = TransactionState.PARTIALLY_COMMITTED;
    }

    public void afterCommit() {
        if (this.state != TransactionState.PARTIALLY_COMMITTED) {
            throw new IllegalStateException("Cannot finish commit. Current state is " + String.valueOf((Object)this.state));
        }
        this.state = TransactionState.COMMITTED;
    }

    public void rollback() {
        if (this.state != TransactionState.ACTIVE && this.state != TransactionState.PARTIALLY_COMMITTED && this.state != TransactionState.FAILED) {
            throw new IllegalStateException("Cannot rollback transaction. Current state is " + String.valueOf((Object)this.state));
        }
        this.state = TransactionState.FAILED;
    }

    public void afterRollback() {
        if (this.state != TransactionState.FAILED) {
            throw new IllegalStateException("Cannot finish rollback. Current state is " + String.valueOf((Object)this.state));
        }
        this.state = TransactionState.ABORTED;
    }

    public boolean isActive() {
        return this.state == TransactionState.ACTIVE;
    }

    public TransactionState getState() {
        return this.state;
    }

    public void verifyActive() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction is not active. Current state is " + String.valueOf((Object)this.state));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transaction other = (Transaction)obj;
        return this.state == other.state;
    }

    public String toString() {
        return this.state != null ? this.state.toString() : "null";
    }
}

