/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.descriptor.AxiomDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.rdf4j.config.RuntimeConfiguration;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.loader.StatementLoader;
import cz.cvut.kbss.ontodriver.rdf4j.util.AxiomBuilder;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;

class AxiomLoader {
    private final RepoConnection connector;
    private final Map<IRI, Assertion> propertyToAssertion;
    private Map<IRI, Assertion> explicitAssertions;
    private Map<IRI, Assertion> inferredAssertions;
    private final RuntimeConfiguration config;

    AxiomLoader(RepoConnection connector, RuntimeConfiguration config) {
        this.connector = connector;
        this.propertyToAssertion = new HashMap<IRI, Assertion>();
        this.config = config;
    }

    Collection<Axiom<?>> loadAxioms(AxiomDescriptor axiomDescriptor) throws Rdf4jDriverException {
        return this.findStatements(axiomDescriptor);
    }

    private Collection<Axiom<?>> findStatements(AxiomDescriptor descriptor) throws Rdf4jDriverException {
        HashSet result = new HashSet();
        Assertion unspecified = this.processAssertions(descriptor);
        AxiomBuilder axiomBuilder = new AxiomBuilder(descriptor.getSubject(), this.propertyToAssertion, unspecified);
        StatementLoader statementLoader = this.createLoader(descriptor.getSubject(), axiomBuilder);
        statementLoader.setLoadAllThreshold(this.config.getLoadAllThreshold());
        if (unspecified == null || !unspecified.isInferred()) {
            statementLoader.setIncludeInferred(false);
            result.addAll(statementLoader.loadAxioms(descriptor, this.explicitAssertions));
        }
        statementLoader.setIncludeInferred(true);
        result.addAll(statementLoader.loadAxioms(descriptor, this.inferredAssertions));
        return result;
    }

    private StatementLoader createLoader(NamedResource individual, AxiomBuilder axiomBuilder) {
        IRI subject = Rdf4jUtils.toRdf4jIri(individual.getIdentifier(), this.connector.getValueFactory());
        return this.config.getStatementLoaderFactory().create(this.connector, (Resource)subject, axiomBuilder);
    }

    private Assertion processAssertions(AxiomDescriptor descriptor) {
        Set assertions = descriptor.getAssertions();
        this.explicitAssertions = new HashMap<IRI, Assertion>(assertions.size());
        this.inferredAssertions = new HashMap<IRI, Assertion>(assertions.size());
        Assertion unspecified = null;
        for (Assertion a : assertions) {
            IRI property = Rdf4jUtils.toRdf4jIri(a.getIdentifier(), this.connector.getValueFactory());
            this.propertyToAssertion.put(property, a);
            if (a.equals((Object)Assertion.createUnspecifiedPropertyAssertion((boolean)a.isInferred()))) {
                unspecified = a;
            }
            if (a.isInferred()) {
                this.inferredAssertions.put(property, a);
                continue;
            }
            this.explicitAssertions.put(property, a);
        }
        return unspecified;
    }

    Collection<Axiom<?>> loadAxioms(NamedResource individual, boolean includeInferred, URI context) throws Rdf4jDriverException {
        AxiomBuilder axiomBuilder = new AxiomBuilder(individual, Collections.emptyMap(), Assertion.createUnspecifiedPropertyAssertion((boolean)includeInferred));
        StatementLoader loader = this.createLoader(individual, axiomBuilder);
        return loader.loadAxioms(context != null ? Collections.singleton(context) : Collections.emptySet());
    }
}

