/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.descriptor.AxiomValueDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import cz.cvut.kbss.ontodriver.rdf4j.util.ValueConverter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;

class AxiomSaver {
    private final RepoConnection connector;
    private final ValueConverter valueConverter;

    AxiomSaver(RepoConnection connector) {
        this.connector = connector;
        this.valueConverter = new ValueConverter(connector.getValueFactory());
    }

    void persistAxioms(AxiomValueDescriptor axiomDescriptor) throws Rdf4jDriverException {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Assertion assertion : axiomDescriptor.getAssertions()) {
            statements.addAll(this.createRdf4jStatements(axiomDescriptor.getSubject(), assertion, axiomDescriptor.getAssertionValues(assertion), axiomDescriptor.getAssertionContext(assertion)));
        }
        if (!statements.isEmpty()) {
            this.connector.addStatements(statements);
        }
    }

    void persistAxioms(NamedResource subject, Map<Assertion, Set<Value<?>>> values, URI context) throws Rdf4jDriverException {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Map.Entry<Assertion, Set<Value<?>>> entry : values.entrySet()) {
            statements.addAll(this.createRdf4jStatements(subject, entry.getKey(), (Collection)entry.getValue(), context));
        }
        if (!statements.isEmpty()) {
            this.connector.addStatements(statements);
        }
    }

    private Collection<? extends Statement> createRdf4jStatements(NamedResource subject, Assertion assertion, Collection<Value<?>> assertionValues, URI assertionContext) throws Rdf4jDriverException {
        ArrayList<Statement> statements = new ArrayList<Statement>(assertionValues.size());
        IRI subjectUri = Rdf4jUtils.toRdf4jIri(subject.getIdentifier(), this.connector.getValueFactory());
        IRI property = Rdf4jUtils.toRdf4jIri(assertion.getIdentifier(), this.connector.getValueFactory());
        IRI context = assertionContext != null ? Rdf4jUtils.toRdf4jIri(assertionContext, this.connector.getValueFactory()) : null;
        for (Value<?> val : assertionValues) {
            if (val == Value.nullValue()) continue;
            org.eclipse.rdf4j.model.Value value = this.valueConverter.toRdf4jValue(assertion, val);
            statements.add(this.createStatement((Resource)subjectUri, property, value, context));
        }
        return statements;
    }

    private Statement createStatement(Resource subject, IRI property, org.eclipse.rdf4j.model.Value value, IRI context) {
        if (context != null) {
            return this.connector.getValueFactory().createStatement(subject, property, value, (Resource)context);
        }
        return this.connector.getValueFactory().createStatement(subject, property, value);
    }
}

