/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.descriptor.AbstractAxiomDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.connector.SubjectPredicateContext;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import cz.cvut.kbss.ontodriver.rdf4j.util.ValueConverter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;

class EpistemicAxiomRemover {
    private final RepoConnection connector;
    private final ValueFactory valueFactory;

    EpistemicAxiomRemover(RepoConnection connector, ValueFactory valueFactory) {
        this.connector = connector;
        this.valueFactory = valueFactory;
    }

    void remove(AbstractAxiomDescriptor axiomDescriptor) throws Rdf4jDriverException {
        IRI individual = Rdf4jUtils.toRdf4jIri(axiomDescriptor.getSubject(), this.valueFactory);
        HashSet<SubjectPredicateContext> toRemove = new HashSet<SubjectPredicateContext>();
        for (Assertion a : axiomDescriptor.getAssertions()) {
            Set contexts = axiomDescriptor.getAssertionContexts(a).stream().map(uri -> Rdf4jUtils.toRdf4jIri(uri, this.valueFactory)).collect(Collectors.toSet());
            toRemove.add(new SubjectPredicateContext((Resource)individual, Rdf4jUtils.toRdf4jIri((NamedResource)a, this.valueFactory), contexts));
        }
        this.connector.removePropertyValues(toRemove);
    }

    void remove(NamedResource individual, Map<Assertion, Set<Value<?>>> values, URI context) throws Rdf4jDriverException {
        IRI repoContext = Rdf4jUtils.toRdf4jIri(context, this.valueFactory);
        IRI subject = Rdf4jUtils.toRdf4jIri(individual.getIdentifier(), this.valueFactory);
        ArrayList<Statement> toRemove = new ArrayList<Statement>();
        ValueConverter valueConverter = new ValueConverter(this.valueFactory);
        for (Map.Entry<Assertion, Set<Value<?>>> entry : values.entrySet()) {
            IRI property = Rdf4jUtils.toRdf4jIri((NamedResource)entry.getKey(), this.valueFactory);
            for (Value<?> val : entry.getValue()) {
                org.eclipse.rdf4j.model.Value rdf4jValue = valueConverter.toRdf4jValue(entry.getKey(), val);
                if (repoContext != null) {
                    toRemove.add(this.valueFactory.createStatement((Resource)subject, property, rdf4jValue, (Resource)repoContext));
                    continue;
                }
                toRemove.add(this.valueFactory.createStatement((Resource)subject, property, rdf4jValue));
            }
        }
        this.connector.removeStatements(toRemove);
    }
}

