/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.Closeable;
import cz.cvut.kbss.ontodriver.Wrapper;
import cz.cvut.kbss.ontodriver.descriptor.AbstractAxiomDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.AxiomDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.AxiomValueDescriptor;
import cz.cvut.kbss.ontodriver.exception.IdentifierGenerationException;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.rdf4j.AxiomLoader;
import cz.cvut.kbss.ontodriver.rdf4j.AxiomSaver;
import cz.cvut.kbss.ontodriver.rdf4j.EpistemicAxiomRemover;
import cz.cvut.kbss.ontodriver.rdf4j.TypesHandler;
import cz.cvut.kbss.ontodriver.rdf4j.config.Constants;
import cz.cvut.kbss.ontodriver.rdf4j.config.RuntimeConfiguration;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.connector.StatementExecutor;
import cz.cvut.kbss.ontodriver.rdf4j.container.ContainerHandler;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.list.ReferencedListHandler;
import cz.cvut.kbss.ontodriver.rdf4j.list.SimpleListHandler;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import cz.cvut.kbss.ontodriver.util.IdentifierUtils;
import cz.cvut.kbss.ontodriver.util.Transaction;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class Rdf4jAdapter
implements Closeable,
Wrapper {
    private static final int ID_GENERATION_THRESHOLD = 64;
    private final RepoConnection connector;
    private final ValueFactory valueFactory;
    private final RuntimeConfiguration config;
    private final Transaction transaction;
    private boolean open = true;

    public Rdf4jAdapter(RepoConnection connector, RuntimeConfiguration config) {
        assert (connector != null);
        this.connector = connector;
        this.valueFactory = connector.getValueFactory();
        this.config = config;
        this.transaction = new Transaction();
    }

    RepoConnection getConnector() {
        return this.connector;
    }

    RuntimeConfiguration getConfig() {
        return this.config;
    }

    public void close() throws OntoDriverException {
        if (!this.open) {
            return;
        }
        try {
            this.connector.close();
        }
        finally {
            this.open = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    void commit() throws Rdf4jDriverException {
        if (this.transaction.isActive()) {
            this.transaction.commit();
            this.connector.commit();
            this.transaction.afterCommit();
        }
    }

    void rollback() throws Rdf4jDriverException {
        if (this.transaction.isActive()) {
            this.transaction.rollback();
            this.connector.rollback();
            this.transaction.afterRollback();
        }
    }

    boolean isConsistent(URI context) {
        return true;
    }

    List<URI> getContexts() throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        List<Resource> contextIds = this.connector.getContexts();
        ArrayList<URI> contexts = new ArrayList<URI>(contextIds.size());
        for (Resource res : contextIds) {
            URI context = Rdf4jUtils.toJavaUri(res);
            if (context == null) continue;
            contexts.add(context);
        }
        return contexts;
    }

    URI generateIdentifier(URI classUri) throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        boolean unique = false;
        URI id = null;
        int counter = 0;
        while (!unique && counter++ < 64) {
            id = IdentifierUtils.generateIdentifier((URI)classUri);
            unique = this.isIdentifierUnique(id, classUri);
        }
        if (!unique) {
            throw new IdentifierGenerationException("Unable to generate a unique identifier.");
        }
        return id;
    }

    private void startTransactionIfNotActive() throws Rdf4jDriverException {
        if (!this.transaction.isActive()) {
            this.connector.begin();
            this.transaction.begin();
        }
    }

    private boolean isIdentifierUnique(URI identifier, URI classUri) throws Rdf4jDriverException {
        return !this.connector.containsStatement((Resource)Rdf4jUtils.toRdf4jIri(identifier, this.valueFactory), RDF.TYPE, (Value)Rdf4jUtils.toRdf4jIri(classUri, this.valueFactory), true, Collections.emptySet());
    }

    boolean contains(Axiom<?> axiom, Set<URI> contexts) throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        Value value = this.axiomObjectToRdf4jValue(axiom);
        return this.connector.containsStatement((Resource)Rdf4jUtils.toRdf4jIri(axiom.getSubject(), this.valueFactory), Rdf4jUtils.toRdf4jIri((NamedResource)axiom.getAssertion(), this.valueFactory), value, axiom.getAssertion().isInferred(), contexts.stream().map(c -> Rdf4jUtils.toRdf4jIri(c, this.valueFactory)).collect(Collectors.toSet()));
    }

    private Value axiomObjectToRdf4jValue(Axiom<?> axiom) {
        IRI value;
        if (Rdf4jUtils.isResourceIdentifier(axiom.getValue().getValue())) {
            value = this.valueFactory.createIRI(axiom.getValue().stringValue());
        } else {
            String lang = axiom.getAssertion().hasLanguage() ? axiom.getAssertion().getLanguage() : Constants.DEFAULT_LANG;
            value = Rdf4jUtils.createLiteral(axiom.getValue().getValue(), lang, this.valueFactory);
        }
        return value;
    }

    boolean isInferred(Axiom<?> axiom, Set<URI> contexts) throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        Value value = this.axiomObjectToRdf4jValue(axiom);
        Statement s = this.valueFactory.createStatement((Resource)Rdf4jUtils.toRdf4jIri(axiom.getSubject(), this.valueFactory), Rdf4jUtils.toRdf4jIri((NamedResource)axiom.getAssertion(), this.valueFactory), value);
        return this.connector.isInferred(s, contexts.stream().map(c -> Rdf4jUtils.toRdf4jIri(c, this.valueFactory)).collect(Collectors.toSet()));
    }

    Collection<Axiom<?>> find(AxiomDescriptor axiomDescriptor) throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        return new AxiomLoader(this.connector, this.config).loadAxioms(axiomDescriptor);
    }

    void persist(AxiomValueDescriptor axiomDescriptor) throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        new AxiomSaver(this.connector).persistAxioms(axiomDescriptor);
    }

    void update(AxiomValueDescriptor axiomDescriptor) throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        new EpistemicAxiomRemover(this.connector, this.valueFactory).remove((AbstractAxiomDescriptor)axiomDescriptor);
        new AxiomSaver(this.connector).persistAxioms(axiomDescriptor);
    }

    void remove(AxiomDescriptor axiomDescriptor) throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        new EpistemicAxiomRemover(this.connector, this.valueFactory).remove((AbstractAxiomDescriptor)axiomDescriptor);
    }

    StatementExecutor getQueryExecutor() {
        return this.connector;
    }

    SimpleListHandler getSimpleListHandler() throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        return new SimpleListHandler(this.connector, this.valueFactory);
    }

    ReferencedListHandler getReferencedListHandler() throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        return new ReferencedListHandler(this.connector, this.valueFactory);
    }

    TypesHandler getTypesHandler() throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        return new TypesHandler(this.connector, this.valueFactory);
    }

    ContainerHandler getContainerHandler() throws Rdf4jDriverException {
        this.startTransactionIfNotActive();
        return new ContainerHandler(this.connector, this.valueFactory);
    }

    public <T> T unwrap(Class<T> cls) throws OntoDriverException {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        if (cls.isAssignableFrom(this.valueFactory.getClass())) {
            return cls.cast(this.valueFactory);
        }
        return (T)this.connector.unwrap(cls);
    }
}

