/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.Connection;
import cz.cvut.kbss.ontodriver.Containers;
import cz.cvut.kbss.ontodriver.Lists;
import cz.cvut.kbss.ontodriver.PreparedStatement;
import cz.cvut.kbss.ontodriver.Properties;
import cz.cvut.kbss.ontodriver.Statement;
import cz.cvut.kbss.ontodriver.Types;
import cz.cvut.kbss.ontodriver.descriptor.AxiomDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.AxiomValueDescriptor;
import cz.cvut.kbss.ontodriver.exception.IdentifierGenerationException;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.rdf4j.ConnectionListener;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jAdapter;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jContainers;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jLists;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jTypes;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.query.Rdf4jPreparedStatement;
import cz.cvut.kbss.ontodriver.rdf4j.query.Rdf4jStatement;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Rdf4jConnection
implements Connection {
    private final Rdf4jAdapter adapter;
    private boolean open;
    private boolean autoCommit;
    private Lists lists;
    private Types types;
    private Properties properties;
    private Containers containers;
    private ConnectionListener<Rdf4jConnection> listener;

    public Rdf4jConnection(Rdf4jAdapter adapter) {
        assert (adapter != null);
        this.adapter = adapter;
        this.open = true;
    }

    public void setLists(Rdf4jLists lists) {
        this.lists = lists;
    }

    public void setTypes(Rdf4jTypes types) {
        this.types = types;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setContainers(Rdf4jContainers containers) {
        this.containers = containers;
    }

    public void setListener(ConnectionListener<Rdf4jConnection> listener) {
        this.ensureOpen();
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public void close() throws Exception {
        if (!this.open) {
            return;
        }
        try {
            this.adapter.close();
            if (this.listener != null) {
                this.listener.connectionClosed(this);
            }
        }
        finally {
            this.open = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void commit() throws OntoDriverException {
        this.ensureOpen();
        if (this.autoCommit) {
            return;
        }
        this.adapter.commit();
    }

    public void rollback() throws OntoDriverException {
        this.ensureOpen();
        if (this.autoCommit) {
            return;
        }
        this.adapter.rollback();
    }

    public void setAutoCommit(boolean autoCommit) {
        this.ensureOpen();
        this.autoCommit = autoCommit;
    }

    public boolean isAutoCommit() {
        this.ensureOpen();
        return this.autoCommit;
    }

    public Statement createStatement() {
        this.ensureOpen();
        return new Rdf4jStatement(this.adapter.getQueryExecutor());
    }

    public PreparedStatement prepareStatement(String sparql) {
        this.ensureOpen();
        Objects.requireNonNull(sparql);
        if (sparql.isEmpty()) {
            throw new IllegalArgumentException("The value for prepared statement cannot be empty.");
        }
        return new Rdf4jPreparedStatement(this.adapter.getQueryExecutor(), sparql);
    }

    public boolean isConsistent(URI context) {
        this.ensureOpen();
        return this.adapter.isConsistent(context);
    }

    public List<URI> getContexts() throws OntoDriverException {
        this.ensureOpen();
        return this.adapter.getContexts();
    }

    public URI generateIdentifier(URI classUri) throws OntoDriverException {
        this.ensureOpen();
        Objects.requireNonNull(classUri);
        try {
            return this.adapter.generateIdentifier(classUri);
        }
        catch (IdentifierGenerationException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    public boolean contains(Axiom<?> axiom, Set<URI> contexts) throws OntoDriverException {
        this.ensureOpen();
        Objects.requireNonNull(axiom);
        Objects.requireNonNull(contexts);
        return this.adapter.contains(axiom, contexts);
    }

    public boolean isInferred(Axiom<?> axiom, Set<URI> contexts) throws OntoDriverException {
        this.ensureOpen();
        Objects.requireNonNull(axiom);
        Objects.requireNonNull(contexts);
        return this.adapter.isInferred(axiom, contexts);
    }

    public Collection<Axiom<?>> find(AxiomDescriptor descriptor) throws OntoDriverException {
        this.ensureOpen();
        Objects.requireNonNull(descriptor);
        try {
            return this.adapter.find(descriptor);
        }
        catch (RuntimeException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    public void persist(AxiomValueDescriptor descriptor) throws OntoDriverException {
        this.ensureOpen();
        Objects.requireNonNull(descriptor);
        try {
            this.adapter.persist(descriptor);
            this.commitIfAuto();
        }
        catch (RuntimeException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    public void update(AxiomValueDescriptor descriptor) throws OntoDriverException {
        this.ensureOpen();
        Objects.requireNonNull(descriptor);
        try {
            this.adapter.update(descriptor);
            this.commitIfAuto();
        }
        catch (RuntimeException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    public void remove(AxiomDescriptor descriptor) throws OntoDriverException {
        this.ensureOpen();
        Objects.requireNonNull(descriptor);
        try {
            this.adapter.remove(descriptor);
            this.commitIfAuto();
        }
        catch (RuntimeException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    public Lists lists() {
        this.ensureOpen();
        assert (this.lists != null);
        return this.lists;
    }

    public Types types() {
        this.ensureOpen();
        assert (this.types != null);
        return this.types;
    }

    public Properties properties() {
        this.ensureOpen();
        assert (this.properties != null);
        return this.properties;
    }

    public Containers containers() {
        this.ensureOpen();
        assert (this.containers != null);
        return this.containers;
    }

    public void ensureOpen() {
        if (!this.open) {
            throw new IllegalStateException("This connection is closed.");
        }
    }

    public void commitIfAuto() throws Rdf4jDriverException {
        if (this.autoCommit) {
            this.adapter.commit();
        }
    }

    public <T> T unwrap(Class<T> cls) throws OntoDriverException {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        return this.adapter.unwrap(cls);
    }
}

