/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.Connection;
import cz.cvut.kbss.ontodriver.DataSource;
import cz.cvut.kbss.ontodriver.OntologyStorageProperties;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jDriver;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.rdf4j.repository.Repository;

public class Rdf4jDataSource
implements DataSource {
    private Rdf4jDriver driver;
    private volatile boolean open = true;
    private boolean connected;
    private OntologyStorageProperties storageProperties;
    private Map<String, String> properties;

    public synchronized void close() throws OntoDriverException {
        if (!this.open) {
            return;
        }
        try {
            if (this.connected) {
                this.driver.close();
            }
        }
        finally {
            this.open = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public synchronized Connection getConnection() throws Rdf4jDriverException {
        this.ensureOpen();
        this.ensureConnected();
        return this.driver.acquireConnection();
    }

    private void ensureOpen() {
        if (!this.open) {
            throw new IllegalStateException("The data source is closed.");
        }
    }

    private void ensureConnected() throws Rdf4jDriverException {
        if (this.connected) {
            return;
        }
        if (this.storageProperties == null) {
            throw new IllegalStateException("Cannot initialize OntoDriver without storageProperties configuration.");
        }
        if (this.properties == null) {
            this.properties = Collections.emptyMap();
        }
        this.driver = new Rdf4jDriver(this.storageProperties, this.properties);
        this.connected = true;
    }

    public void setStorageProperties(OntologyStorageProperties storageProperties) {
        this.ensureOpen();
        this.storageProperties = Objects.requireNonNull(storageProperties);
    }

    public void setProperties(Map<String, String> properties) {
        this.ensureOpen();
        this.properties = Objects.requireNonNull(properties);
    }

    public synchronized void setRepository(Repository repository) throws Rdf4jDriverException {
        this.ensureOpen();
        this.ensureConnected();
        try {
            this.driver.setRepository(repository);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new Rdf4jDriverException(e);
        }
    }
}

