/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.Closeable;
import cz.cvut.kbss.ontodriver.Connection;
import cz.cvut.kbss.ontodriver.OntologyStorageProperties;
import cz.cvut.kbss.ontodriver.config.ConfigurationParameter;
import cz.cvut.kbss.ontodriver.config.DriverConfigParam;
import cz.cvut.kbss.ontodriver.config.DriverConfiguration;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.ConnectionListener;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jAdapter;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jConnection;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jContainers;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jLists;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jProperties;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jTypes;
import cz.cvut.kbss.ontodriver.rdf4j.config.Rdf4jConfigParam;
import cz.cvut.kbss.ontodriver.rdf4j.config.RuntimeConfiguration;
import cz.cvut.kbss.ontodriver.rdf4j.connector.ConnectionFactory;
import cz.cvut.kbss.ontodriver.rdf4j.connector.init.Rdf4jFactoryOfFactories;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.loader.StatementLoaderFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.repository.Repository;

class Rdf4jDriver
implements Closeable,
ConnectionListener<Rdf4jConnection> {
    private static final List<ConfigurationParameter> CONFIGS = List.of(DriverConfigParam.AUTO_COMMIT, Rdf4jConfigParam.USE_INFERENCE, Rdf4jConfigParam.USE_VOLATILE_STORAGE, Rdf4jConfigParam.LOAD_ALL_THRESHOLD, Rdf4jConfigParam.RECONNECT_ATTEMPTS, Rdf4jConfigParam.REPOSITORY_CONFIG, Rdf4jConfigParam.INFERENCE_IN_DEFAULT_CONTEXT, Rdf4jConfigParam.TRANSACTION_ISOLATION_LEVEL, Rdf4jConfigParam.MAX_CONNECTION_POOL_SIZE, Rdf4jConfigParam.CONNECTION_REQUEST_TIMEOUT);
    private final DriverConfiguration configuration;
    private boolean open;
    private final ConnectionFactory connectionFactory;
    private final StatementLoaderFactory statementLoaderFactory;
    private final Set<Rdf4jConnection> openedConnections;

    Rdf4jDriver(OntologyStorageProperties storageProperties, Map<String, String> properties) throws Rdf4jDriverException {
        assert (storageProperties != null);
        assert (properties != null);
        this.configuration = new DriverConfiguration(storageProperties);
        this.configuration.addConfiguration(properties, CONFIGS);
        this.openedConnections = new HashSet<Rdf4jConnection>();
        Rdf4jFactoryOfFactories factory = new Rdf4jFactoryOfFactories(this.configuration);
        this.connectionFactory = factory.createConnectorFactory();
        this.statementLoaderFactory = factory.createStatementLoaderFactory();
        this.open = true;
    }

    public void close() throws OntoDriverException {
        if (!this.open) {
            return;
        }
        try {
            for (Rdf4jConnection c : this.openedConnections) {
                c.removeListener();
                c.close();
            }
            this.connectionFactory.close();
        }
        catch (OntoDriverException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Rdf4jDriverException(e);
        }
        finally {
            this.open = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    Connection acquireConnection() {
        assert (this.open);
        RuntimeConfiguration config = new RuntimeConfiguration(this.configuration);
        config.setStatementLoaderFactory(this.statementLoaderFactory);
        Rdf4jAdapter adapter = new Rdf4jAdapter(this.connectionFactory.createStorageConnection(), config);
        Rdf4jConnection c = new Rdf4jConnection(adapter);
        c.setLists(new Rdf4jLists(adapter, c::ensureOpen, c::commitIfAuto));
        c.setTypes(new Rdf4jTypes(adapter, c::ensureOpen, c::commitIfAuto));
        c.setProperties(new Rdf4jProperties(adapter, c::ensureOpen, c::commitIfAuto));
        c.setContainers(new Rdf4jContainers(adapter, c::ensureOpen, c::commitIfAuto));
        this.openedConnections.add(c);
        c.setListener(this);
        return c;
    }

    @Override
    public void connectionClosed(Rdf4jConnection connection) {
        if (connection == null) {
            return;
        }
        this.openedConnections.remove(connection);
    }

    void setRepository(Repository repository) throws Rdf4jDriverException {
        assert (this.open);
        this.connectionFactory.setRepository(repository);
    }
}

