/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.Lists;
import cz.cvut.kbss.ontodriver.descriptor.ListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ListValueDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ReferencedListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ReferencedListValueDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.SimpleListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.SimpleListValueDescriptor;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.rdf4j.Procedure;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jAdapter;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import java.util.List;
import java.util.Objects;

public class Rdf4jLists
implements Lists {
    private final Rdf4jAdapter adapter;
    private final Procedure beforeCallback;
    private final Procedure afterChangeCallback;

    public Rdf4jLists(Rdf4jAdapter adapter, Procedure beforeCallback, Procedure afterChangeCallback) {
        this.adapter = adapter;
        this.beforeCallback = beforeCallback;
        this.afterChangeCallback = afterChangeCallback;
    }

    public List<Axiom<NamedResource>> loadSimpleList(SimpleListDescriptor descriptor) throws OntoDriverException {
        this.verifyArgs((ListDescriptor)descriptor);
        return this.adapter.getSimpleListHandler().loadList(descriptor);
    }

    private void verifyArgs(ListDescriptor descriptor) throws Rdf4jDriverException {
        this.beforeCallback.execute();
        Objects.requireNonNull(descriptor);
    }

    public void persistSimpleList(SimpleListValueDescriptor descriptor) throws OntoDriverException {
        this.verifyArgs((ListDescriptor)descriptor);
        this.adapter.getSimpleListHandler().persistList((ListValueDescriptor)descriptor);
        this.afterChangeCallback.execute();
    }

    public void updateSimpleList(SimpleListValueDescriptor descriptor) throws OntoDriverException {
        this.verifyArgs((ListDescriptor)descriptor);
        this.adapter.getSimpleListHandler().updateList((ListValueDescriptor)descriptor);
        this.afterChangeCallback.execute();
    }

    public List<Axiom<?>> loadReferencedList(ReferencedListDescriptor descriptor) throws OntoDriverException {
        this.verifyArgs((ListDescriptor)descriptor);
        return this.adapter.getReferencedListHandler().loadList(descriptor);
    }

    public <T> void persistReferencedList(ReferencedListValueDescriptor<T> descriptor) throws OntoDriverException {
        this.verifyArgs((ListDescriptor)descriptor);
        this.adapter.getReferencedListHandler().persistList((ListValueDescriptor)descriptor);
        this.afterChangeCallback.execute();
    }

    public <T> void updateReferencedList(ReferencedListValueDescriptor<T> descriptor) throws OntoDriverException {
        this.verifyArgs((ListDescriptor)descriptor);
        this.adapter.getReferencedListHandler().updateList((ListValueDescriptor)descriptor);
        this.afterChangeCallback.execute();
    }
}

