/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.Properties;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.AxiomLoader;
import cz.cvut.kbss.ontodriver.rdf4j.AxiomSaver;
import cz.cvut.kbss.ontodriver.rdf4j.EpistemicAxiomRemover;
import cz.cvut.kbss.ontodriver.rdf4j.Procedure;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jAdapter;
import cz.cvut.kbss.ontodriver.rdf4j.config.RuntimeConfiguration;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Rdf4jProperties
implements Properties {
    private final RepoConnection connector;
    private final RuntimeConfiguration config;
    private final Procedure beforeCallback;
    private final Procedure afterChangeCallback;

    public Rdf4jProperties(Rdf4jAdapter adapter, Procedure beforeCallback, Procedure afterChangeCallback) {
        this.connector = adapter.getConnector();
        this.config = adapter.getConfig();
        this.beforeCallback = beforeCallback;
        this.afterChangeCallback = afterChangeCallback;
    }

    public Collection<Axiom<?>> getProperties(NamedResource individual, URI context, boolean includeInferred) throws Rdf4jDriverException {
        this.beforeCallback.execute();
        return new AxiomLoader(this.connector, this.config).loadAxioms(individual, includeInferred, context);
    }

    public void addProperties(NamedResource individual, URI context, Map<Assertion, Set<Value<?>>> properties) throws OntoDriverException {
        this.beforeCallback.execute();
        new AxiomSaver(this.connector).persistAxioms(individual, properties, context);
        this.afterChangeCallback.execute();
    }

    public void removeProperties(NamedResource individual, URI context, Map<Assertion, Set<Value<?>>> properties) throws OntoDriverException {
        new EpistemicAxiomRemover(this.connector, this.connector.getValueFactory()).remove(individual, properties, context);
        this.afterChangeCallback.execute();
    }
}

