/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.Types;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.rdf4j.Procedure;
import cz.cvut.kbss.ontodriver.rdf4j.Rdf4jAdapter;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class Rdf4jTypes
implements Types {
    private final Rdf4jAdapter adapter;
    private final Procedure beforeCallback;
    private final Procedure afterChangeCallback;

    public Rdf4jTypes(Rdf4jAdapter adapter, Procedure beforeCallback, Procedure afterChangeCallback) {
        this.adapter = adapter;
        this.beforeCallback = beforeCallback;
        this.afterChangeCallback = afterChangeCallback;
    }

    public Set<Axiom<URI>> getTypes(NamedResource individual, Collection<URI> contexts, boolean includeInferred) throws OntoDriverException {
        Objects.requireNonNull(individual);
        this.beforeCallback.execute();
        return this.adapter.getTypesHandler().getTypes(individual, contexts, includeInferred);
    }

    public void addTypes(NamedResource individual, URI context, Set<URI> types) throws OntoDriverException {
        this.verifyValidity(individual, types);
        if (!types.isEmpty()) {
            this.adapter.getTypesHandler().addTypes(individual, context, types);
        }
        this.afterChangeCallback.execute();
    }

    private void verifyValidity(NamedResource individual, Set<URI> types) throws Rdf4jDriverException {
        Objects.requireNonNull(individual);
        Objects.requireNonNull(types);
        this.beforeCallback.execute();
    }

    public void removeTypes(NamedResource individual, URI context, Set<URI> types) throws OntoDriverException {
        this.verifyValidity(individual, types);
        if (!types.isEmpty()) {
            this.adapter.getTypesHandler().removeTypes(individual, context, types);
        }
        this.afterChangeCallback.execute();
    }
}

