/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j;

import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.AxiomImpl;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

class TypesHandler {
    private final RepoConnection connector;
    private final ValueFactory valueFactory;

    TypesHandler(RepoConnection connector, ValueFactory valueFactory) {
        this.connector = connector;
        this.valueFactory = valueFactory;
    }

    Set<Axiom<URI>> getTypes(NamedResource individual, Collection<URI> contexts, boolean includeInferred) throws Rdf4jDriverException {
        Collection<Statement> statements = this.getTypesStatements(individual, contexts, includeInferred);
        if (statements.isEmpty()) {
            return Collections.emptySet();
        }
        return TypesHandler.resolveTypes(individual, includeInferred, statements);
    }

    private Collection<Statement> getTypesStatements(NamedResource individual, Collection<URI> contexts, boolean includeInferred) throws Rdf4jDriverException {
        IRI subject = Rdf4jUtils.toRdf4jIri(individual.getIdentifier(), this.valueFactory);
        return this.connector.findStatements((Resource)subject, RDF.TYPE, null, includeInferred, contexts.stream().map(c -> Rdf4jUtils.toRdf4jIri(c, this.valueFactory)).collect(Collectors.toSet()));
    }

    private static Set<Axiom<URI>> resolveTypes(NamedResource individual, boolean includeInferred, Collection<Statement> statements) {
        HashSet<Axiom<URI>> types = new HashSet<Axiom<URI>>(statements.size());
        Assertion clsAssertion = Assertion.createClassAssertion((boolean)includeInferred);
        for (Statement stmt : statements) {
            assert (stmt.getObject() instanceof Resource);
            URI type = Rdf4jUtils.toJavaUri((Resource)stmt.getObject());
            if (type == null) continue;
            types.add((Axiom<URI>)new AxiomImpl(individual, clsAssertion, new Value((Object)type)));
        }
        return types;
    }

    void addTypes(NamedResource individual, URI context, Set<URI> types) throws Rdf4jDriverException {
        Collection<Statement> statements = this.prepareStatements(individual, context, types);
        this.connector.addStatements(statements);
    }

    private Collection<Statement> prepareStatements(NamedResource individual, URI context, Set<URI> types) {
        IRI subject = Rdf4jUtils.toRdf4jIri(individual.getIdentifier(), this.valueFactory);
        IRI contextUri = Rdf4jUtils.toRdf4jIri(context, this.valueFactory);
        ArrayList<Statement> statements = new ArrayList<Statement>(types.size());
        for (URI type : types) {
            statements.add(this.valueFactory.createStatement((Resource)subject, RDF.TYPE, (org.eclipse.rdf4j.model.Value)this.valueFactory.createIRI(type.toString()), (Resource)contextUri));
        }
        return statements;
    }

    void removeTypes(NamedResource individual, URI context, Set<URI> types) throws Rdf4jDriverException {
        Collection<Statement> statements = this.prepareStatements(individual, context, types);
        this.connector.removeStatements(statements);
    }
}

