/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.connector;

import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.connector.ConnectionFactory;
import cz.cvut.kbss.ontodriver.rdf4j.connector.ConnectionFactoryConfig;
import cz.cvut.kbss.ontodriver.rdf4j.connector.GraphDBStorageConnection;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.connector.StorageConnection;
import cz.cvut.kbss.ontodriver.rdf4j.connector.StorageConnector;
import java.util.Objects;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.repository.Repository;

public final class ConnectionFactoryImpl
implements ConnectionFactory {
    private boolean open = true;
    private final StorageConnector connector;
    private final boolean isGraphDB;
    private final IsolationLevel txIsolationLevel;

    public ConnectionFactoryImpl(StorageConnector connector) {
        this(connector, new ConnectionFactoryConfig(false, null));
    }

    public ConnectionFactoryImpl(StorageConnector connector, ConnectionFactoryConfig config) {
        this.connector = Objects.requireNonNull(connector);
        this.isGraphDB = config.isGraphDB();
        this.txIsolationLevel = config.txIsolationLevel();
    }

    @Override
    public RepoConnection createStorageConnection() {
        this.ensureOpen();
        if (this.isGraphDB) {
            return new GraphDBStorageConnection(this.connector, this.txIsolationLevel);
        }
        return new StorageConnection(this.connector, this.txIsolationLevel);
    }

    private void ensureOpen() {
        if (!this.open) {
            throw new IllegalStateException("The factory is closed!");
        }
    }

    @Override
    public void setRepository(Repository repository) {
        this.ensureOpen();
        this.connector.setRepository(repository);
    }

    @Override
    public synchronized void close() throws OntoDriverException {
        if (!this.open) {
            return;
        }
        this.connector.close();
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }
}

