/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.connector;

import cz.cvut.kbss.ontodriver.rdf4j.connector.QueryResult;
import cz.cvut.kbss.ontodriver.rdf4j.connector.StatementExecutor;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.query.QuerySpecification;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

class ConnectionStatementExecutor
implements StatementExecutor {
    private final RepositoryConnection connection;

    ConnectionStatementExecutor(RepositoryConnection connection) {
        this.connection = connection;
    }

    @Override
    public TupleQueryResult executeSelectQuery(QuerySpecification query) throws Rdf4jDriverException {
        try {
            TupleQuery tq = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, query.getQuery());
            tq.setIncludeInferred(query.isIncludeInference());
            return new QueryResult(tq.evaluate(), this.connection);
        }
        catch (MalformedQueryException | QueryEvaluationException | RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    @Override
    public boolean executeBooleanQuery(QuerySpecification query) throws Rdf4jDriverException {
        try {
            BooleanQuery bq = this.connection.prepareBooleanQuery(QueryLanguage.SPARQL, query.getQuery());
            bq.setIncludeInferred(query.isIncludeInference());
            return bq.evaluate();
        }
        catch (MalformedQueryException | QueryEvaluationException | RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    @Override
    public void executeUpdate(QuerySpecification query) throws Rdf4jDriverException {
        try {
            Update u = this.connection.prepareUpdate(QueryLanguage.SPARQL, query.getQuery());
            u.setIncludeInferred(query.isIncludeInference());
            u.execute();
        }
        catch (MalformedQueryException | UpdateExecutionException | RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }
}

