/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.connector;

import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.connector.ConnectionStatementExecutor;
import cz.cvut.kbss.ontodriver.rdf4j.connector.Rdf4jConnectionProvider;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.connector.SubjectPredicateContext;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.query.QuerySpecification;
import cz.cvut.kbss.ontodriver.rdf4j.util.ThrowingFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageConnection
implements RepoConnection {
    private static final Logger LOG = LoggerFactory.getLogger(StorageConnection.class);
    private boolean open;
    final Rdf4jConnectionProvider connectionProvider;
    private final IsolationLevel isolationLevel;
    private RepositoryConnection connection;

    public StorageConnection(Rdf4jConnectionProvider connectionProvider, IsolationLevel isolationLevel) {
        this.connectionProvider = connectionProvider;
        this.isolationLevel = isolationLevel;
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() throws Rdf4jDriverException {
        if (!this.open) {
            return;
        }
        LOG.debug("Closing repository connector.");
        try {
            if (this.connection != null) {
                if (this.connection.isActive()) {
                    this.connection.rollback();
                }
                this.connection.close();
            }
        }
        catch (RepositoryException e) {
            throw new Rdf4jDriverException("Exception caught when closing RDF4J repository connection.", e);
        }
        finally {
            this.open = false;
        }
    }

    @Override
    public TupleQueryResult executeSelectQuery(QuerySpecification query) throws Rdf4jDriverException {
        return new ConnectionStatementExecutor(this.connectionProvider.acquireConnection()).executeSelectQuery(query);
    }

    @Override
    public boolean executeBooleanQuery(QuerySpecification query) throws Rdf4jDriverException {
        return this.withConnection(conn -> new ConnectionStatementExecutor((RepositoryConnection)conn).executeBooleanQuery(query));
    }

    protected <R> R withConnection(ThrowingFunction<RepositoryConnection, R> call) throws Rdf4jDriverException {
        if (this.connection != null) {
            return call.apply(this.connection);
        }
        try (RepositoryConnection conn = this.connectionProvider.acquireConnection();){
            R r = call.apply(conn);
            return r;
        }
    }

    @Override
    public void executeUpdate(QuerySpecification query) throws Rdf4jDriverException {
        if (this.connection != null) {
            new ConnectionStatementExecutor(this.connection).executeUpdate(query);
        } else {
            try (RepositoryConnection conn = this.connectionProvider.acquireConnection();){
                new ConnectionStatementExecutor(conn).executeUpdate(query);
            }
        }
    }

    @Override
    public List<Resource> getContexts() throws Rdf4jDriverException {
        return this.withConnection(conn -> {
            try {
                return this.connection.getContextIDs().stream().collect(Collectors.toList());
            }
            catch (RepositoryException e) {
                throw new Rdf4jDriverException(e);
            }
        });
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.connectionProvider.getValueFactory();
    }

    @Override
    public void begin() throws Rdf4jDriverException {
        this.connection = this.connectionProvider.acquireConnection();
        try {
            LOG.trace("Begin storage transaction.");
            this.connection.begin(this.isolationLevel);
        }
        catch (RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    @Override
    public void commit() throws Rdf4jDriverException {
        assert (this.connection != null);
        try {
            LOG.trace("Commit storage transaction.");
            this.connection.commit();
            this.connection.close();
            this.connection = null;
        }
        catch (RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    @Override
    public void rollback() throws Rdf4jDriverException {
        assert (this.connection != null);
        try {
            LOG.trace("Rollback storage transaction.");
            this.connection.rollback();
            this.connection.close();
            this.connection = null;
        }
        catch (RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    @Override
    public void addStatements(Collection<Statement> statements) throws Rdf4jDriverException {
        this.verifyTransactionActive();
        assert (this.connection != null);
        try {
            this.connection.add(statements, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    protected void verifyTransactionActive() {
        if (this.connection == null || !this.connection.isActive()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeStatements(Collection<Statement> statements) throws Rdf4jDriverException {
        this.verifyTransactionActive();
        assert (this.connection != null);
        try {
            this.connection.remove(statements, new Resource[0]);
        }
        catch (RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    @Override
    public void removePropertyValues(Collection<SubjectPredicateContext> spc) throws Rdf4jDriverException {
        this.verifyTransactionActive();
        assert (this.connection != null);
        try {
            spc.forEach(spcItem -> this.connection.remove(spcItem.subject(), spcItem.predicate(), null, (Resource[])spcItem.contexts().toArray(Resource[]::new)));
        }
        catch (RepositoryException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    @Override
    public Collection<Statement> findStatements(Resource subject, IRI property, Value value, boolean includeInferred) throws Rdf4jDriverException {
        return this.findStatements(subject, property, value, includeInferred, Collections.emptySet());
    }

    @Override
    public Collection<Statement> findStatements(Resource subject, IRI property, Value value, boolean includeInferred, Set<IRI> context) throws Rdf4jDriverException {
        return this.withConnection(conn -> {
            try {
                return conn.getStatements(subject, property, null, includeInferred, (Resource[])context.toArray(new IRI[0])).stream().collect(Collectors.toList());
            }
            catch (RepositoryException e) {
                throw new Rdf4jDriverException(e);
            }
        });
    }

    @Override
    public boolean containsStatement(Resource subject, IRI property, Value value, boolean includeInferred, Set<IRI> contexts) throws Rdf4jDriverException {
        assert (contexts != null);
        return this.withConnection(conn -> {
            try {
                return conn.hasStatement(subject, property, value, includeInferred, (Resource[])contexts.toArray(new IRI[0]));
            }
            catch (RepositoryException e) {
                throw new Rdf4jDriverException(e);
            }
        });
    }

    @Override
    public boolean isInferred(Statement statement, Set<IRI> contexts) throws Rdf4jDriverException {
        assert (contexts != null);
        return this.withConnection(conn -> {
            try {
                IRI[] ctxArr = contexts.toArray(new IRI[0]);
                return conn.hasStatement(statement, true, (Resource[])ctxArr) && !this.connection.hasStatement(statement, false, (Resource[])ctxArr);
            }
            catch (RepositoryException e) {
                throw new Rdf4jDriverException(e);
            }
        });
    }

    public <T> T unwrap(Class<T> cls) throws OntoDriverException {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        if (cls.isAssignableFrom(RepositoryConnection.class)) {
            return cls.cast(this.connection);
        }
        return (T)this.connectionProvider.unwrap(cls);
    }
}

