/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.connector;

import cz.cvut.kbss.ontodriver.Closeable;
import cz.cvut.kbss.ontodriver.Wrapper;
import cz.cvut.kbss.ontodriver.config.ConfigurationParameter;
import cz.cvut.kbss.ontodriver.config.DriverConfiguration;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.config.Rdf4jConfigParam;
import cz.cvut.kbss.ontodriver.rdf4j.connector.Rdf4jConnectionProvider;
import cz.cvut.kbss.ontodriver.rdf4j.connector.init.RemoteRepositoryWrapper;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.exception.RepositoryCreationException;
import cz.cvut.kbss.ontodriver.rdf4j.exception.RepositoryNotFoundException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryProvider;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.config.SailRepositoryConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.helpers.SailWrapper;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.config.SchemaCachingRDFSInferencerConfig;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.nativerdf.config.NativeStoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageConnector
implements Closeable,
Rdf4jConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StorageConnector.class);
    private static final String[] KNOWN_REMOTE_SCHEMES = new String[]{"http", "https", "ftp"};
    private static final String LOCAL_NATIVE_REPO = "repositories/";
    private static final String FILE_SCHEME = "file";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private final DriverConfiguration configuration;
    private final int maxReconnectAttempts;
    private RepositoryManager manager;
    private Repository repository;
    private boolean open;

    public StorageConnector(DriverConfiguration configuration) throws Rdf4jDriverException {
        this.configuration = configuration;
        this.maxReconnectAttempts = StorageConnector.resolveMaxReconnectAttempts(configuration);
    }

    private static int resolveMaxReconnectAttempts(DriverConfiguration config) throws Rdf4jDriverException {
        int attempts = config.getProperty((ConfigurationParameter)Rdf4jConfigParam.RECONNECT_ATTEMPTS, 5);
        if (attempts < 0) {
            throw new Rdf4jDriverException("Invalid value of configuration parameter cz.cvut.kbss.ontodriver.rdf4j.reconnect-attempts. Must be a non-negative integer.");
        }
        return attempts;
    }

    public void initializeRepository() throws Rdf4jDriverException {
        URI serverUri = this.configuration.getStorageProperties().getPhysicalURI();
        LOG.debug("Initializing connector to repository at {}", (Object)serverUri);
        try {
            boolean isRemote = StorageConnector.isRemoteRepository(serverUri);
            this.repository = isRemote ? this.connectToRemoteRepository(serverUri.toString()) : this.createLocalRepository();
            this.verifyRepositoryCreated(serverUri, isRemote);
            this.repository.init();
        }
        catch (RepositoryException | RepositoryConfigException e) {
            throw new Rdf4jDriverException("Failed to acquire RDF4J repository connection.", e);
        }
        this.open = true;
    }

    private static boolean isRemoteRepository(URI uri) {
        String scheme = uri.getScheme();
        for (String s : KNOWN_REMOTE_SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    private Repository connectToRemoteRepository(String repoUri) {
        this.manager = RepositoryProvider.getRepositoryManagerOfRepository((String)repoUri);
        RemoteRepositoryManager remoteManager = (RemoteRepositoryManager)this.manager;
        String username = this.configuration.getStorageProperties().getUsername();
        if (username != null) {
            String password = this.configuration.getStorageProperties().getPassword();
            remoteManager.setUsernameAndPassword(username, password);
        }
        return this.connectToRemote(repoUri, 1);
    }

    private Repository connectToRemote(String repoUri, int attempts) {
        try {
            return new RemoteRepositoryWrapper((HTTPRepository)this.manager.getRepository(RepositoryProvider.getRepositoryIdOfRepository((String)repoUri)), this.configuration);
        }
        catch (RepositoryException e) {
            if (attempts < this.maxReconnectAttempts) {
                LOG.warn("Unable to connect to repository {}. Error is: {}. Retrying...", (Object)repoUri, (Object)e.getMessage());
                return this.connectToRemote(repoUri, attempts + 1);
            }
            LOG.error("Threshold of failed connection attempts reached, throwing exception.");
            throw e;
        }
    }

    private Repository createLocalRepository() {
        if (this.configuration.isSet((ConfigurationParameter)Rdf4jConfigParam.REPOSITORY_CONFIG)) {
            return this.createRepositoryFromConfig();
        }
        URI localUri = this.configuration.getStorageProperties().getPhysicalURI();
        if (!StorageConnector.isFileUri(localUri) && this.configuration.is((ConfigurationParameter)Rdf4jConfigParam.USE_VOLATILE_STORAGE)) {
            return this.createInMemoryRepository();
        }
        return this.createNativeRepository(this.configuration, localUri.toString());
    }

    private Repository createRepositoryFromConfig() {
        LOG.trace("Creating local repository from repository config file.");
        RepositoryConfig repoConfig = this.loadRepositoryConfig();
        this.manager = RepositoryProvider.getRepositoryManager((String)this.getRepositoryManagerBaseDir().orElse(""));
        this.manager.addRepositoryConfig(repoConfig);
        return this.manager.getRepository(this.getRepositoryId());
    }

    private RepositoryConfig loadRepositoryConfig() {
        RepositoryConfig repositoryConfig;
        block10: {
            InputStream is = this.getConfigFileContent();
            try {
                Model configModel = Rio.parse((InputStream)is, (String)"", (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
                Set resources = configModel.filter(null, RDF.TYPE, (Value)CONFIG.Rep.Repository, new Resource[0]).subjects();
                if (resources.isEmpty()) {
                    resources = configModel.filter(null, RDF.TYPE, (Value)RepositoryConfigSchema.REPOSITORY, new Resource[0]).subjects();
                }
                assert (resources.size() == 1);
                repositoryConfig = RepositoryConfig.create((Model)configModel, (Resource)((Resource)resources.iterator().next()));
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RepositoryCreationException("Unable to create repository from the specified configuration.", e);
                }
            }
            is.close();
        }
        return repositoryConfig;
    }

    private InputStream getConfigFileContent() {
        String configPath = this.configuration.getProperty((ConfigurationParameter)Rdf4jConfigParam.REPOSITORY_CONFIG);
        LOG.trace("Loading repository configuration file content from {}.", (Object)configPath);
        if (configPath.startsWith(CLASSPATH_PREFIX)) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(configPath.substring(CLASSPATH_PREFIX.length()));
            if (is == null) {
                throw new RepositoryCreationException("Unable to find repository configuration file on classpath location " + configPath);
            }
            return is;
        }
        try {
            return new FileInputStream(configPath);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryCreationException("Unable to find repository configuration file at " + configPath, e);
        }
    }

    private Optional<String> getRepositoryManagerBaseDir() {
        String physicalUri = this.configuration.getStorageProperties().getPhysicalURI().toString();
        String[] tmp = physicalUri.split(LOCAL_NATIVE_REPO);
        return tmp.length == 2 ? Optional.of(tmp[0]) : Optional.empty();
    }

    private String getRepositoryId() {
        String physicalUri = this.configuration.getStorageProperties().getPhysicalURI().toString();
        String[] tmp = physicalUri.split(LOCAL_NATIVE_REPO);
        if (tmp.length != 2) {
            return physicalUri;
        }
        String repoId = tmp[1];
        return repoId.charAt(repoId.length() - 1) == '/' ? repoId.substring(0, repoId.length() - 1) : repoId;
    }

    private static boolean isFileUri(URI uri) {
        return uri.getScheme() != null && uri.getScheme().equals(FILE_SCHEME);
    }

    private Repository createInMemoryRepository() {
        LOG.trace("Creating local in-memory repository.");
        MemoryStore ms = new MemoryStore();
        if (this.configuration.is((ConfigurationParameter)Rdf4jConfigParam.USE_INFERENCE)) {
            return new SailRepository((Sail)new SchemaCachingRDFSInferencer((NotifyingSail)ms));
        }
        return new SailRepository((Sail)ms);
    }

    private Repository createNativeRepository(DriverConfiguration configuration, String localUri) {
        LOG.trace("Creating local native repository at {}", (Object)localUri);
        StorageConnector.validateNativeStorePath(localUri);
        try {
            this.manager = RepositoryProvider.getRepositoryManagerOfRepository((String)localUri);
            String repoId = this.getRepositoryId();
            RepositoryConfig cfg = StorageConnector.createLocalNativeRepositoryConfig(repoId, configuration);
            this.manager.addRepositoryConfig(cfg);
            return this.manager.getRepository(repoId);
        }
        catch (RepositoryException | RepositoryConfigException e) {
            throw new RepositoryCreationException("Unable to create local repository at " + localUri, e);
        }
    }

    private static void validateNativeStorePath(String path) {
        if (path.split(LOCAL_NATIVE_REPO).length != 2) {
            throw new RepositoryCreationException("Unsupported local RDF4J repository path. Expected file://path/repositories/id but got " + path);
        }
    }

    private static RepositoryConfig createLocalNativeRepositoryConfig(String repoId, DriverConfiguration configuration) {
        NativeStoreConfig backend = new NativeStoreConfig();
        if (configuration.is((ConfigurationParameter)Rdf4jConfigParam.USE_INFERENCE)) {
            backend = new SchemaCachingRDFSInferencerConfig((SailImplConfig)backend);
        }
        SailRepositoryConfig repoType = new SailRepositoryConfig((SailImplConfig)backend);
        return new RepositoryConfig(repoId, (RepositoryImplConfig)repoType);
    }

    private void verifyRepositoryCreated(URI serverUri, boolean isRemote) {
        if (this.repository == null) {
            if (isRemote) {
                throw new RepositoryNotFoundException("Unable to reach repository at " + String.valueOf(serverUri));
            }
            throw new RepositoryCreationException("Unable to create local repository at " + String.valueOf(serverUri));
        }
    }

    public void setRepository(Repository newRepository) {
        Objects.requireNonNull(newRepository);
        this.verifyOpen();
        if (!StorageConnector.isInMemoryRepository(this.repository)) {
            throw new UnsupportedOperationException("Cannot replace repository which is not in-memory.");
        }
        this.repository.shutDown();
        assert (newRepository.isInitialized());
        this.repository = newRepository;
    }

    private static boolean isInMemoryRepository(Repository repo) {
        if (!(repo instanceof SailRepository)) {
            return false;
        }
        Sail sail = ((SailRepository)repo).getSail();
        while (sail instanceof SailWrapper) {
            sail = ((SailWrapper)sail).getBaseSail();
        }
        return sail instanceof MemoryStore;
    }

    @Override
    public ValueFactory getValueFactory() {
        this.verifyOpen();
        return this.repository.getValueFactory();
    }

    @Override
    public RepositoryConnection acquireConnection() throws Rdf4jDriverException {
        this.verifyOpen();
        if (!this.repository.isInitialized()) {
            this.repository.init();
        }
        LOG.trace("Acquiring repository connection.");
        return this.acquire(1);
    }

    private RepositoryConnection acquire(int attempts) throws Rdf4jDriverException {
        try {
            return this.repository.getConnection();
        }
        catch (RepositoryException e) {
            if (attempts < this.maxReconnectAttempts) {
                LOG.warn("Unable to acquire repository connection. Error is: {}. Retrying...", (Object)e.getMessage());
                return this.acquire(attempts + 1);
            }
            LOG.error("Threshold of failed connection acquisition attempts reached, throwing exception.");
            throw new Rdf4jDriverException(e);
        }
    }

    public void close() throws OntoDriverException {
        if (!this.open) {
            return;
        }
        try {
            this.repository.shutDown();
            if (this.manager != null) {
                this.manager.shutDown();
            }
        }
        catch (RuntimeException e) {
            throw new Rdf4jDriverException("Exception caught when closing repository connector.", e);
        }
        finally {
            this.open = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    private void verifyOpen() {
        if (!this.open) {
            throw new IllegalStateException("Connector is not open.");
        }
    }

    public <T> T unwrap(Class<T> cls) throws OntoDriverException {
        this.verifyOpen();
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        if (cls.isAssignableFrom(this.repository.getClass())) {
            return cls.cast(this.repository);
        }
        if (this.repository instanceof Wrapper) {
            return (T)((Wrapper)this.repository).unwrap(cls);
        }
        throw new Rdf4jDriverException("No class of type " + String.valueOf(cls) + " found.");
    }
}

