/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.connector.init;

import cz.cvut.kbss.ontodriver.config.ConfigurationParameter;
import cz.cvut.kbss.ontodriver.config.DriverConfiguration;
import cz.cvut.kbss.ontodriver.rdf4j.config.Rdf4jConfigParam;
import java.io.IOException;
import org.apache.http.HttpConnection;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClientFactory {
    private HttpClientFactory() {
        throw new AssertionError();
    }

    static HttpClient createHttpClient(DriverConfiguration configuration) {
        RequestConfig customRequestConfig = RequestConfig.custom().setCookieSpec("standard").setConnectionRequestTimeout(HttpClientFactory.getConnectionRequestTimeout(configuration)).build();
        int maxConnections = HttpClientFactory.getMaxConnections(configuration);
        return HttpClientBuilder.create().evictExpiredConnections().setRetryHandler((HttpRequestRetryHandler)new RetryHandlerStale()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new ServiceUnavailableRetryHandler()).useSystemProperties().setMaxConnPerRoute(maxConnections).setMaxConnTotal(maxConnections).setDefaultRequestConfig(customRequestConfig).build();
    }

    private static int getConnectionRequestTimeout(DriverConfiguration config) {
        return config.getProperty((ConfigurationParameter)Rdf4jConfigParam.CONNECTION_REQUEST_TIMEOUT, 30000);
    }

    private static int getMaxConnections(DriverConfiguration config) {
        int defaultMaxConnections = Math.max(20, Runtime.getRuntime().availableProcessors() * 2);
        return config.getProperty((ConfigurationParameter)Rdf4jConfigParam.MAX_CONNECTION_POOL_SIZE, defaultMaxConnections);
    }

    private static class RetryHandlerStale
    implements HttpRequestRetryHandler {
        private final Logger logger = LoggerFactory.getLogger(RetryHandlerStale.class);

        private RetryHandlerStale() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retryRequest(IOException ioe, int count, HttpContext context) {
            if (count > 1) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpConnection conn = clientContext.getConnection();
            if (conn != null) {
                RetryHandlerStale retryHandlerStale = this;
                synchronized (retryHandlerStale) {
                    if (conn.isStale()) {
                        try {
                            this.logger.warn("Closing stale connection");
                            conn.close();
                            return true;
                        }
                        catch (IOException e) {
                            this.logger.error("Error closing stale connection", (Throwable)e);
                        }
                    }
                }
            }
            return false;
        }
    }

    private static class ServiceUnavailableRetryHandler
    implements ServiceUnavailableRetryStrategy {
        private final Logger logger = LoggerFactory.getLogger(ServiceUnavailableRetryHandler.class);

        private ServiceUnavailableRetryHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            if (response.getStatusLine().getStatusCode() != 408) {
                return false;
            }
            String keepAlive = System.getProperty("http.keepAlive", "true");
            if (!"true".equalsIgnoreCase(keepAlive)) {
                return false;
            }
            int pooledConnections = Integer.parseInt(System.getProperty("http.maxConnections", "5"));
            if (executionCount > pooledConnections + 1) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpConnection conn = clientContext.getConnection();
            ServiceUnavailableRetryHandler serviceUnavailableRetryHandler = this;
            synchronized (serviceUnavailableRetryHandler) {
                try {
                    this.logger.info("Cleaning up closed connection");
                    conn.close();
                    return true;
                }
                catch (IOException e) {
                    this.logger.error("Error cleaning up closed connection", (Throwable)e);
                }
            }
            return false;
        }

        public long getRetryInterval() {
            return 1000L;
        }
    }
}

