/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.connector.init;

import cz.cvut.kbss.ontodriver.config.ConfigurationParameter;
import cz.cvut.kbss.ontodriver.config.DriverConfiguration;
import cz.cvut.kbss.ontodriver.rdf4j.config.Rdf4jConfigParam;
import cz.cvut.kbss.ontodriver.rdf4j.connector.ConnectionFactory;
import cz.cvut.kbss.ontodriver.rdf4j.connector.ConnectionFactoryConfig;
import cz.cvut.kbss.ontodriver.rdf4j.connector.ConnectionFactoryImpl;
import cz.cvut.kbss.ontodriver.rdf4j.connector.StorageConnector;
import cz.cvut.kbss.ontodriver.rdf4j.connector.init.FactoryOfFactories;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.loader.DefaultContextInferenceStatementLoaderFactory;
import cz.cvut.kbss.ontodriver.rdf4j.loader.DefaultStatementLoaderFactory;
import cz.cvut.kbss.ontodriver.rdf4j.loader.GraphDBStatementLoaderFactory;
import cz.cvut.kbss.ontodriver.rdf4j.loader.StatementLoaderFactory;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rdf4jFactoryOfFactories
implements FactoryOfFactories {
    private static final Logger LOG = LoggerFactory.getLogger(Rdf4jFactoryOfFactories.class);
    static final String GRAPHDB_INTERNAL_ID_PROPERTY = "http://www.ontotext.com/owlim/entity#id";
    private final DriverConfiguration config;
    private final StorageConnector connector;
    private final boolean isGraphDB;

    public Rdf4jFactoryOfFactories(DriverConfiguration config) throws Rdf4jDriverException {
        this.config = config;
        this.connector = new StorageConnector(config);
        this.connector.initializeRepository();
        this.isGraphDB = this.isRepositoryGraphDB();
    }

    @Override
    public ConnectionFactory createConnectorFactory() throws Rdf4jDriverException {
        return new ConnectionFactoryImpl(this.connector, this.resolveFactoryConfig());
    }

    @Override
    public StatementLoaderFactory createStatementLoaderFactory() {
        if (this.config.is((ConfigurationParameter)Rdf4jConfigParam.INFERENCE_IN_DEFAULT_CONTEXT)) {
            return new DefaultContextInferenceStatementLoaderFactory();
        }
        if (this.isGraphDB) {
            return new GraphDBStatementLoaderFactory();
        }
        return new DefaultStatementLoaderFactory();
    }

    ConnectionFactoryConfig resolveFactoryConfig() throws Rdf4jDriverException {
        String isolationLevelConfig = this.config.getProperty((ConfigurationParameter)Rdf4jConfigParam.TRANSACTION_ISOLATION_LEVEL);
        if (isolationLevelConfig != null) {
            Optional<IsolationLevels> optionalLevel = Stream.of(IsolationLevels.values()).filter(level -> level.toString().equals(isolationLevelConfig)).findAny();
            if (optionalLevel.isEmpty()) {
                throw new Rdf4jDriverException("Unsupported transaction isolation level value '" + isolationLevelConfig + "'.");
            }
            LOG.debug("Configured to use RDF4J transaction isolation level '{}'.", (Object)optionalLevel.get());
            return new ConnectionFactoryConfig(this.isGraphDB, (IsolationLevel)optionalLevel.get());
        }
        return new ConnectionFactoryConfig(this.isGraphDB, null);
    }

    private boolean isRepositoryGraphDB() throws Rdf4jDriverException {
        boolean bl;
        block9: {
            RepositoryConnection connection = this.connector.acquireConnection();
            try {
                ValueFactory vf = connection.getValueFactory();
                BooleanQuery query = connection.prepareBooleanQuery("ASK { ?x ?internalId ?y }");
                query.setBinding("internalId", (Value)vf.createIRI(GRAPHDB_INTERNAL_ID_PROPERTY));
                boolean result = query.evaluate();
                if (result) {
                    LOG.debug("Underlying repository is GraphDB.");
                }
                bl = result;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new Rdf4jDriverException(e);
                }
            }
            connection.close();
        }
        return bl;
    }
}

