/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.connector.init;

import cz.cvut.kbss.ontodriver.Wrapper;
import cz.cvut.kbss.ontodriver.config.DriverConfiguration;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.connector.init.HttpClientFactory;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import java.io.File;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SharedHttpClientSessionManager;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepository;

public class RemoteRepositoryWrapper
implements Repository,
Wrapper {
    private final HTTPRepository delegate;
    private HttpClient httpClient;

    public RemoteRepositoryWrapper(HTTPRepository delegate, DriverConfiguration configuration) {
        this.delegate = delegate;
        this.httpClient = HttpClientFactory.createHttpClient(configuration);
        HttpClientSessionManager sessionManager = delegate.getHttpClientSessionManager();
        if (sessionManager instanceof SharedHttpClientSessionManager) {
            ((SharedHttpClientSessionManager)sessionManager).setHttpClient(this.httpClient);
        }
    }

    public void setDataDir(File file) {
        this.delegate.setDataDir(file);
    }

    public File getDataDir() {
        return this.delegate.getDataDir();
    }

    public void init() throws RepositoryException {
        this.delegate.init();
    }

    public boolean isInitialized() {
        return this.delegate.isInitialized();
    }

    public void shutDown() throws RepositoryException {
        this.delegate.shutDown();
        if (this.httpClient != null) {
            HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
            this.httpClient = null;
        }
    }

    public boolean isWritable() throws RepositoryException {
        return this.delegate.isWritable();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return this.delegate.getConnection();
    }

    public ValueFactory getValueFactory() {
        return this.delegate.getValueFactory();
    }

    public <T> T unwrap(Class<T> cls) throws OntoDriverException {
        if (cls.isAssignableFrom(this.delegate.getClass())) {
            return cls.cast(this.delegate);
        }
        throw new Rdf4jDriverException("No instance of class " + String.valueOf(cls) + " found.");
    }
}

