/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.container;

import cz.cvut.kbss.ontodriver.descriptor.ContainerDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ContainerValueDescriptor;
import cz.cvut.kbss.ontodriver.exception.IntegrityConstraintViolatedException;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.AxiomImpl;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.util.ValueConverter;
import cz.cvut.kbss.ontodriver.util.IdentifierUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerHandler.class);
    private static final String MEMBERSHIP_PROPERTY_URI_BASE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_";
    private static final int MEMBERSHIP_PROPERTY_URI_BASE_LENGTH = "http://www.w3.org/1999/02/22-rdf-syntax-ns#_".length();
    private final RepoConnection connector;
    private final ValueFactory vf;

    public ContainerHandler(RepoConnection connector, ValueFactory vf) {
        this.connector = connector;
        this.vf = vf;
    }

    public List<Axiom<?>> loadContainer(ContainerDescriptor descriptor) throws Rdf4jDriverException {
        Objects.requireNonNull(descriptor);
        Set<IRI> contexts = this.contexts(descriptor);
        Optional<Resource> container = this.findContainer(descriptor, contexts);
        if (container.isEmpty()) {
            return List.of();
        }
        Collection<Statement> content = this.connector.findStatements(container.get(), null, null, false, contexts);
        return content.stream().filter(s -> s.getPredicate().stringValue().startsWith(MEMBERSHIP_PROPERTY_URI_BASE)).sorted(ContainerHandler::statementComparator).map(s -> ValueConverter.fromRdf4jValue(descriptor.getProperty(), s.getObject())).filter(Optional::isPresent).map(o -> new AxiomImpl(descriptor.getOwner(), descriptor.getProperty(), new Value(o.get()))).toList();
    }

    private Optional<Resource> findContainer(ContainerDescriptor descriptor, Set<IRI> contexts) throws Rdf4jDriverException {
        IRI property;
        IRI owner = this.vf.createIRI(descriptor.getOwner().getIdentifier().toString());
        Collection<Statement> statements = this.connector.findStatements((Resource)owner, property = this.vf.createIRI(descriptor.getProperty().getIdentifier().toString()), null, false, contexts);
        if (statements.isEmpty()) {
            return Optional.empty();
        }
        if (statements.size() > 1) {
            throw new IntegrityConstraintViolatedException("Expected a single value of property <" + String.valueOf(property) + ">, but got multiple.");
        }
        org.eclipse.rdf4j.model.Value containerValue = statements.iterator().next().getObject();
        assert (containerValue.isResource());
        return Optional.of((Resource)containerValue);
    }

    private static int statementComparator(Statement s1, Statement s2) {
        String p1 = s1.getPredicate().toString();
        String p2 = s2.getPredicate().toString();
        try {
            int p1Number = Integer.parseInt(p1.substring(MEMBERSHIP_PROPERTY_URI_BASE_LENGTH));
            int p2Number = Integer.parseInt(p2.substring(MEMBERSHIP_PROPERTY_URI_BASE_LENGTH));
            return p1Number - p2Number;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to determine container membership property number.", e);
        }
    }

    private Set<IRI> contexts(ContainerDescriptor descriptor) {
        return descriptor.getContext() != null ? Set.of(this.vf.createIRI(descriptor.getContext().toString())) : Set.of();
    }

    public <T> void persistContainer(ContainerValueDescriptor<T> descriptor) throws Rdf4jDriverException {
        Objects.requireNonNull(descriptor);
        if (descriptor.getValues().isEmpty()) {
            LOG.trace("Container is empty, nothing to persist.");
            return;
        }
        IRI containerIri = this.generateContainerIri(descriptor);
        IRI contextIri = descriptor.getContext() != null ? this.vf.createIRI(descriptor.getContext().toString()) : null;
        ArrayList<Statement> toPersist = new ArrayList<Statement>();
        toPersist.add(this.vf.createStatement((Resource)this.toRdf4jIri(descriptor.getOwner().getIdentifier()), this.toRdf4jIri(descriptor.getProperty().getIdentifier()), (org.eclipse.rdf4j.model.Value)containerIri, (Resource)contextIri));
        toPersist.add(this.vf.createStatement((Resource)containerIri, RDF.TYPE, (org.eclipse.rdf4j.model.Value)this.toRdf4jIri(descriptor.getType()), (Resource)contextIri));
        toPersist.addAll(this.generateContainerContent(descriptor, (Resource)containerIri, contextIri));
        this.connector.addStatements(toPersist);
    }

    private IRI toRdf4jIri(URI uri) {
        return this.vf.createIRI(uri.toString());
    }

    private IRI generateContainerIri(ContainerValueDescriptor<?> descriptor) throws Rdf4jDriverException {
        IRI iri;
        do {
            iri = this.vf.createIRI(descriptor.getOwner().getIdentifier().toString() + descriptor.getType().getFragment().toLowerCase() + "_" + IdentifierUtils.randomInt());
            LOG.trace("Generated container IRI: <{}>", (Object)iri);
        } while (this.connector.containsStatement((Resource)iri, null, null, false, Set.of()));
        return iri;
    }

    private <T> List<Statement> generateContainerContent(ContainerValueDescriptor<T> descriptor, Resource container, IRI contextIri) throws Rdf4jDriverException {
        ArrayList<Statement> result = new ArrayList<Statement>(descriptor.getValues().size());
        ValueConverter valueConverter = new ValueConverter(this.vf);
        for (int i = 0; i < descriptor.getValues().size(); ++i) {
            Object value = descriptor.getValues().get(i);
            result.add(this.vf.createStatement(container, this.vf.createIRI(MEMBERSHIP_PROPERTY_URI_BASE + (i + 1)), valueConverter.toRdf4jValue(descriptor.getProperty(), value), (Resource)contextIri));
        }
        return result;
    }

    public <T> void updateContainer(ContainerValueDescriptor<T> descriptor) throws Rdf4jDriverException {
        Objects.requireNonNull(descriptor);
        IRI context = descriptor.getContext() != null ? this.vf.createIRI(descriptor.getContext().toString()) : null;
        Set<IRI> contexts = context != null ? Set.of(context) : Set.of();
        Optional<Resource> container = this.findContainer((ContainerDescriptor)descriptor, contexts);
        if (container.isEmpty()) {
            this.persistContainer(descriptor);
            return;
        }
        if (descriptor.getValues().isEmpty()) {
            this.deleteContainer(descriptor.getOwner(), descriptor.getProperty(), container.get(), contexts);
            return;
        }
        this.clearContainer(container.get(), contexts);
        this.connector.addStatements(this.generateContainerContent(descriptor, container.get(), context));
    }

    private void clearContainer(Resource container, Set<IRI> contexts) throws Rdf4jDriverException {
        Collection<Statement> content = this.connector.findStatements(container, null, null, false, contexts);
        this.connector.removeStatements(content.stream().filter(Predicate.not(s -> RDF.TYPE.equals((Object)s.getPredicate()))).toList());
    }

    private void deleteContainer(NamedResource owner, Assertion property, Resource container, Set<IRI> contexts) throws Rdf4jDriverException {
        ArrayList<Statement> toRemove = new ArrayList<Statement>(this.connector.findStatements(container, null, null, false, contexts));
        toRemove.addAll(this.connector.findStatements((Resource)this.toRdf4jIri(owner.getIdentifier()), this.toRdf4jIri(property.getIdentifier()), (org.eclipse.rdf4j.model.Value)container, false, contexts));
        this.connector.removeStatements(toRemove);
    }
}

