/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.list;

import cz.cvut.kbss.ontodriver.descriptor.ListDescriptor;
import cz.cvut.kbss.ontodriver.exception.IntegrityConstraintViolatedException;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.list.ListIterator;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import cz.cvut.kbss.ontodriver.rdf4j.util.ValueConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;

abstract class AbstractListIterator<JT>
implements ListIterator<JT> {
    protected final Resource listOwner;
    protected final IRI hasListProperty;
    protected final IRI hasNextProperty;
    protected final IRI context;
    protected final boolean includeInferred;
    protected final RepoConnection connector;
    protected final ValueFactory vf;
    protected final ValueConverter valueConverter;

    public AbstractListIterator(ListDescriptor listDescriptor, RepoConnection connector, ValueFactory vf) {
        this.listOwner = Rdf4jUtils.toRdf4jIri(listDescriptor.getListOwner().getIdentifier(), vf);
        this.hasListProperty = Rdf4jUtils.toRdf4jIri(listDescriptor.getListProperty().getIdentifier(), vf);
        this.hasNextProperty = Rdf4jUtils.toRdf4jIri(listDescriptor.getNextNode().getIdentifier(), vf);
        this.context = Rdf4jUtils.toRdf4jIri(listDescriptor.getContext(), vf);
        this.includeInferred = listDescriptor.getListProperty().isInferred();
        this.connector = connector;
        this.vf = vf;
        this.valueConverter = new ValueConverter(vf);
    }

    protected Set<IRI> contexts() {
        return this.context != null ? Collections.singleton(this.context) : Collections.emptySet();
    }

    protected void checkSuccessorMax(Collection<Statement> stmts, IRI property) {
        if (new HashSet<Statement>(stmts).size() > 1) {
            throw this.icViolatedException(property, stmts.size());
        }
    }

    protected IntegrityConstraintViolatedException icViolatedException(IRI property, int count) {
        return new IntegrityConstraintViolatedException("Invalid number of values found for assertion " + String.valueOf(property) + ". Expected 1, got " + count);
    }

    protected void checkObjectIsResource(Statement stmt) {
        if (!stmt.getObject().isResource()) {
            throw new IntegrityConstraintViolatedException("Invalid property value. Expected object property value, got literal.");
        }
    }
}

