/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.list;

import cz.cvut.kbss.ontodriver.descriptor.ListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ListValueDescriptor;
import cz.cvut.kbss.ontodriver.exception.IntegrityConstraintViolatedException;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.list.ListIterator;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;

abstract class ListHandler<VD extends ListValueDescriptor<?>> {
    final RepoConnection connector;
    final ValueFactory vf;

    ListHandler(RepoConnection connector, ValueFactory vf) {
        this.connector = connector;
        this.vf = vf;
    }

    public void persistList(VD listValueDescriptor) throws Rdf4jDriverException {
        if (listValueDescriptor.getValues().isEmpty()) {
            return;
        }
        ArrayList<Statement> statements = new ArrayList<Statement>(listValueDescriptor.getValues().size());
        IRI head = this.createListHead(listValueDescriptor, statements);
        statements.addAll(this.createListRest(head, listValueDescriptor));
        this.connector.addStatements(statements);
    }

    protected abstract IRI createListHead(VD var1, Collection<Statement> var2) throws Rdf4jDriverException;

    protected abstract List<Statement> createListRest(IRI var1, VD var2) throws Rdf4jDriverException;

    public void updateList(VD listValueDescriptor) throws Rdf4jDriverException {
        if (listValueDescriptor.getValues().isEmpty()) {
            this.clearList(listValueDescriptor);
        } else if (this.isOldListEmpty((Resource)this.owner((ListDescriptor)listValueDescriptor), this.hasList((ListDescriptor)listValueDescriptor), listValueDescriptor.getListProperty().isInferred(), this.contexts((ListDescriptor)listValueDescriptor))) {
            this.persistList(listValueDescriptor);
        } else {
            this.mergeList(listValueDescriptor);
        }
    }

    protected abstract void clearList(VD var1) throws Rdf4jDriverException;

    protected abstract void mergeList(VD var1) throws Rdf4jDriverException;

    boolean isOldListEmpty(Resource owner, IRI hasListProperty, boolean includeInferred, Set<IRI> contexts) throws Rdf4jDriverException {
        Collection<Statement> stmts = this.connector.findStatements(owner, hasListProperty, null, includeInferred, contexts);
        return stmts.isEmpty();
    }

    void removeObsoletes(ListIterator<?> it) throws Rdf4jDriverException {
        while (it.hasNext()) {
            it.nextNode();
            it.remove();
        }
    }

    Resource extractListNode(Collection<Statement> stmts, IRI nodeAssertion) {
        if (stmts.size() > 1) {
            throw new IntegrityConstraintViolatedException("Invalid number of values found for assertion " + String.valueOf(nodeAssertion) + ". Expected 1, got " + stmts.size());
        }
        Value val = stmts.iterator().next().getObject();
        if (!(val instanceof Resource)) {
            throw new IntegrityConstraintViolatedException("Invalid property value. Expected object property value, got literal.");
        }
        return (Resource)val;
    }

    Set<IRI> contexts(ListDescriptor listDescriptor) {
        IRI ctx = this.toRdf4jIri(listDescriptor.getContext());
        return ctx != null ? Collections.singleton(ctx) : Collections.emptySet();
    }

    IRI context(ListDescriptor listDescriptor) {
        return this.toRdf4jIri(listDescriptor.getContext());
    }

    IRI owner(ListDescriptor listDescriptor) {
        return this.toRdf4jIri(listDescriptor.getListOwner().getIdentifier());
    }

    IRI hasList(ListDescriptor listDescriptor) {
        return this.toRdf4jIri(listDescriptor.getListProperty().getIdentifier());
    }

    IRI hasNext(ListDescriptor listDescriptor) {
        return this.toRdf4jIri(listDescriptor.getNextNode().getIdentifier());
    }

    IRI toRdf4jIri(URI uri) {
        return Rdf4jUtils.toRdf4jIri(uri, this.vf);
    }

    static final class MergeResult {
        final int i;
        final Resource previous;

        MergeResult(int i, Resource node) {
            this.i = i;
            this.previous = node;
        }
    }
}

