/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.list;

import cz.cvut.kbss.ontodriver.descriptor.ListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ReferencedListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ReferencedListValueDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.list.ListHandler;
import cz.cvut.kbss.ontodriver.rdf4j.list.ListIterator;
import cz.cvut.kbss.ontodriver.rdf4j.list.ReferencedListHelper;
import cz.cvut.kbss.ontodriver.rdf4j.list.ReferencedListIterator;
import cz.cvut.kbss.ontodriver.rdf4j.util.ValueConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class ReferencedListHandler
extends ListHandler<ReferencedListValueDescriptor<?>> {
    private int sequenceCounter = 0;
    private final ValueConverter valueConverter;

    public ReferencedListHandler(RepoConnection connector, ValueFactory vf) {
        super(connector, vf);
        this.valueConverter = new ValueConverter(vf);
    }

    public List<Axiom<?>> loadList(ReferencedListDescriptor listDescriptor) throws Rdf4jDriverException {
        ArrayList axioms = new ArrayList();
        ReferencedListIterator it = new ReferencedListIterator(listDescriptor, this.connector, this.vf);
        while (it.hasNext()) {
            axioms.add(it.nextAxiom());
        }
        return axioms;
    }

    @Override
    protected IRI createListHead(ReferencedListValueDescriptor<?> listValueDescriptor, Collection<Statement> statements) throws Rdf4jDriverException {
        IRI owner = this.owner((ListDescriptor)listValueDescriptor);
        IRI hasList = this.hasList((ListDescriptor)listValueDescriptor);
        IRI hasContent = this.hasContent((ReferencedListDescriptor)listValueDescriptor);
        IRI context = this.context((ListDescriptor)listValueDescriptor);
        IRI nodeUri = this.generateSequenceNode(owner, context);
        statements.add(this.vf.createStatement((Resource)owner, hasList, (Value)nodeUri, (Resource)context));
        Collection<Value> nodeContent = this.toRdf4jValue(listValueDescriptor.getNodeContent(), listValueDescriptor.getValues().get(0));
        nodeContent.forEach(item -> statements.add(this.vf.createStatement((Resource)nodeUri, hasContent, item, (Resource)context)));
        return nodeUri;
    }

    private IRI hasContent(ReferencedListDescriptor listDescriptor) {
        return this.toRdf4jIri(listDescriptor.getNodeContent().getIdentifier());
    }

    private Collection<Value> toRdf4jValue(Assertion a, Object value) throws Rdf4jDriverException {
        return new ReferencedListHelper(this.valueConverter).toRdf4jValue(a, value);
    }

    private IRI generateSequenceNode(IRI owner, IRI context) throws Rdf4jDriverException {
        IRI node;
        Collection<Statement> stmts;
        boolean unique;
        String uriBase = owner.stringValue();
        while (!(unique = (stmts = this.connector.findStatements((Resource)(node = this.vf.createIRI(uriBase + "-SEQ_" + this.sequenceCounter++)), null, null, false, context != null ? Collections.singleton(context) : Collections.emptySet())).isEmpty())) {
        }
        return node;
    }

    @Override
    protected List<Statement> createListRest(IRI headNode, ReferencedListValueDescriptor<?> listValueDescriptor) throws Rdf4jDriverException {
        IRI owner = this.owner((ListDescriptor)listValueDescriptor);
        IRI hasNext = this.hasNext((ListDescriptor)listValueDescriptor);
        IRI hasContent = this.hasContent((ReferencedListDescriptor)listValueDescriptor);
        IRI context = this.context((ListDescriptor)listValueDescriptor);
        IRI previous = headNode;
        ArrayList<Statement> statements = new ArrayList<Statement>(listValueDescriptor.getValues().size() * 2);
        Iterator it = listValueDescriptor.getValues().iterator();
        it.next();
        while (it.hasNext()) {
            Collection<Value> content = this.toRdf4jValue(listValueDescriptor.getNodeContent(), it.next());
            previous = this.appendListNode(owner, hasNext, hasContent, content, context, (Resource)previous, statements);
        }
        this.createNilTerminal((Resource)previous, hasNext, (ReferencedListDescriptor)listValueDescriptor).ifPresent(statements::add);
        return statements;
    }

    private IRI appendListNode(IRI owner, IRI hasNext, IRI hasContent, Collection<Value> content, IRI context, Resource previous, Collection<Statement> statements) throws Rdf4jDriverException {
        IRI node = this.generateSequenceNode(owner, context);
        statements.add(this.vf.createStatement(previous, hasNext, (Value)node, (Resource)context));
        content.forEach(item -> statements.add(this.vf.createStatement((Resource)node, hasContent, item, (Resource)context)));
        return node;
    }

    private Optional<Statement> createNilTerminal(Resource lastNode, IRI hasNext, ReferencedListDescriptor descriptor) {
        return descriptor.isTerminatedByNil() ? Optional.of(this.vf.createStatement(lastNode, hasNext, (Value)RDF.NIL)) : Optional.empty();
    }

    @Override
    protected void clearList(ReferencedListValueDescriptor<?> listDescriptor) throws Rdf4jDriverException {
        Collection<Statement> next;
        IRI hasNext = this.hasNext((ListDescriptor)listDescriptor);
        IRI hasContent = this.hasContent((ReferencedListDescriptor)listDescriptor);
        boolean includeInferred = listDescriptor.getListProperty().isInferred();
        Set<IRI> context = this.contexts((ListDescriptor)listDescriptor);
        IRI previous = this.owner((ListDescriptor)listDescriptor);
        IRI currentProperty = this.hasList((ListDescriptor)listDescriptor);
        ArrayList<Statement> toRemove = new ArrayList<Statement>();
        do {
            if (!(next = this.connector.findStatements((Resource)previous, currentProperty, null, includeInferred, context)).isEmpty()) {
                Resource node = this.extractListNode(next, currentProperty);
                toRemove.addAll(next);
                toRemove.addAll(this.connector.findStatements(node, hasContent, null, includeInferred, context));
                previous = node;
            }
            currentProperty = hasNext;
        } while (!next.isEmpty());
        this.connector.removeStatements(toRemove);
    }

    @Override
    protected void mergeList(ReferencedListValueDescriptor<?> listDescriptor) throws Rdf4jDriverException {
        ReferencedListIterator it = new ReferencedListIterator((ReferencedListDescriptor)listDescriptor, this.connector, this.vf);
        ListHandler.MergeResult mergeResult = this.mergeWithOriginalList(listDescriptor, it);
        this.removeObsoletes(it);
        assert (mergeResult.i > 0);
        assert (mergeResult.previous != null);
        if (mergeResult.i < listDescriptor.getValues().size()) {
            this.appendNewNodes(listDescriptor, mergeResult);
        }
    }

    <V> ListHandler.MergeResult mergeWithOriginalList(ReferencedListValueDescriptor<V> listDescriptor, ListIterator<V> it) throws Rdf4jDriverException {
        int i;
        Resource node = null;
        for (i = 0; it.hasNext() && i < listDescriptor.getValues().size(); ++i) {
            Object newNode;
            node = it.nextNode();
            V content = it.currentContent();
            if (content.equals(newNode = listDescriptor.getValues().get(i))) continue;
            it.replaceCurrentWith(newNode);
        }
        return new ListHandler.MergeResult(i, node);
    }

    <V> void appendNewNodes(ReferencedListValueDescriptor<V> listDescriptor, ListHandler.MergeResult mergeResult) throws Rdf4jDriverException {
        int i = mergeResult.i;
        Resource previous = mergeResult.previous;
        IRI owner = this.owner((ListDescriptor)listDescriptor);
        IRI hasNext = this.hasNext((ListDescriptor)listDescriptor);
        IRI hasContent = this.hasContent((ReferencedListDescriptor)listDescriptor);
        IRI context = this.context((ListDescriptor)listDescriptor);
        assert (i > 0);
        ArrayList<Statement> toAdd = new ArrayList<Statement>((listDescriptor.getValues().size() - i) * 2);
        if (listDescriptor.isTerminatedByNil()) {
            this.removePreviousNilTerminal(previous, hasNext, context);
        }
        while (i < listDescriptor.getValues().size()) {
            Collection<Value> content = this.toRdf4jValue(listDescriptor.getNodeContent(), listDescriptor.getValues().get(i));
            previous = this.appendListNode(owner, hasNext, hasContent, content, context, previous, toAdd);
            ++i;
        }
        this.createNilTerminal(previous, hasNext, (ReferencedListDescriptor)listDescriptor).ifPresent(toAdd::add);
        this.connector.addStatements(toAdd);
    }

    private void removePreviousNilTerminal(Resource lastNode, IRI hasNext, IRI context) throws Rdf4jDriverException {
        this.connector.removeStatements(Set.of(this.vf.createStatement(lastNode, hasNext, (Value)RDF.NIL, (Resource)context)));
    }
}

