/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.list;

import cz.cvut.kbss.ontodriver.descriptor.ListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.ReferencedListDescriptor;
import cz.cvut.kbss.ontodriver.exception.IntegrityConstraintViolatedException;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.AxiomImpl;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Translations;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.list.AbstractListIterator;
import cz.cvut.kbss.ontodriver.rdf4j.list.ReferencedListHelper;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

class ReferencedListIterator<T>
extends AbstractListIterator<T> {
    private final ReferencedListDescriptor listDescriptor;
    private final IRI hasContentProperty;
    private IRI currentProperty;
    private Statement currentNode;
    private Collection<Statement> currentContent;
    private Collection<Statement> next;

    public ReferencedListIterator(ReferencedListDescriptor listDescriptor, RepoConnection connector, ValueFactory vf) throws Rdf4jDriverException {
        super((ListDescriptor)listDescriptor, connector, vf);
        this.listDescriptor = listDescriptor;
        this.hasContentProperty = Rdf4jUtils.toRdf4jIri(listDescriptor.getNodeContent().getIdentifier(), vf);
        this.currentProperty = this.hasListProperty;
        this.init();
    }

    private void init() throws Rdf4jDriverException {
        this.next = this.connector.findStatements(this.listOwner, this.hasListProperty, null, this.includeInferred, this.contexts());
    }

    @Override
    public boolean hasNext() {
        return !this.next.isEmpty() && !this.isNextNil();
    }

    private boolean isNextNil() {
        assert (this.next != null);
        return RDF.NIL.equals((Object)this.next.iterator().next().getObject());
    }

    @Override
    public Resource nextNode() throws Rdf4jDriverException {
        this.nextInternal();
        return (Resource)this.currentNode.getObject();
    }

    private void nextInternal() throws Rdf4jDriverException {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        super.checkSuccessorMax(this.next, this.currentProperty);
        this.currentNode = this.next.iterator().next();
        this.currentProperty = this.currentNode.getPredicate();
        this.checkObjectIsResource(this.currentNode);
        Resource elem = (Resource)this.currentNode.getObject();
        this.currentContent = this.getNodeContent(elem);
        this.next = this.connector.findStatements(elem, this.hasNextProperty, null, this.includeInferred, this.contexts());
    }

    private Collection<Statement> getNodeContent(Resource node) throws Rdf4jDriverException {
        Collection<Statement> elements = this.connector.findStatements(node, this.hasContentProperty, null, this.includeInferred, this.contexts());
        this.checkSuccessorMax(elements, this.hasContentProperty);
        if (elements.isEmpty()) {
            throw new IntegrityConstraintViolatedException("Node " + String.valueOf(node) + " has no content.");
        }
        return elements;
    }

    @Override
    protected void checkSuccessorMax(Collection<Statement> stmts, IRI property) {
        HashSet<String> langs = new HashSet<String>();
        HashSet<Statement> statements = new HashSet<Statement>(stmts);
        if (statements.size() == 1) {
            return;
        }
        for (Statement s : statements) {
            if (!s.getObject().isLiteral()) {
                throw this.icViolatedException(property, statements.size());
            }
            Literal literal = (Literal)s.getObject();
            if (literal.getLanguage().isPresent() && !langs.contains(literal.getLanguage().get())) {
                langs.add((String)literal.getLanguage().get());
                continue;
            }
            throw this.icViolatedException(property, statements.size());
        }
    }

    @Override
    public T currentContent() {
        if (this.currentContent.size() == 1) {
            return (T)ReferencedListIterator.fromRdf4jValue(this.currentContent.iterator().next().getObject());
        }
        Translations mls = this.currentContentToMultilingualString();
        return (T)mls;
    }

    private static Object fromRdf4jValue(org.eclipse.rdf4j.model.Value value) {
        return value.isLiteral() ? Rdf4jUtils.getLiteralValue((Literal)value) : NamedResource.create((String)value.stringValue());
    }

    @Override
    public Axiom<T> nextAxiom() throws Rdf4jDriverException {
        this.nextInternal();
        if (this.currentContent.size() == 1) {
            org.eclipse.rdf4j.model.Value obj = this.currentContent.iterator().next().getObject();
            return new AxiomImpl(NamedResource.create((String)this.currentContent.iterator().next().getSubject().stringValue()), this.listDescriptor.getNodeContent(), new Value(ReferencedListIterator.fromRdf4jValue(obj)));
        }
        Translations mls = this.currentContentToMultilingualString();
        return new AxiomImpl(NamedResource.create((String)this.currentContent.iterator().next().getSubject().stringValue()), this.listDescriptor.getNodeContent(), new Value((Object)mls));
    }

    private Translations currentContentToMultilingualString() {
        Translations mls = new Translations();
        this.currentContent.forEach(s -> {
            assert (s.getObject().isLiteral());
            Literal literal = (Literal)s.getObject();
            assert (literal.getLanguage().isPresent());
            mls.set((String)literal.getLanguage().get(), literal.getLabel());
        });
        return mls;
    }

    @Override
    public void remove() throws Rdf4jDriverException {
        assert (this.currentNode.getObject() instanceof Resource);
        ArrayList<Statement> toRemove = new ArrayList<Statement>();
        toRemove.add(this.currentNode);
        toRemove.addAll(this.currentContent);
        if (!this.next.isEmpty()) {
            toRemove.addAll(this.next);
            Statement stmt = this.next.iterator().next();
            this.checkObjectIsResource(stmt);
            Resource nextNode = (Resource)stmt.getObject();
            Statement connectNext = this.vf.createStatement(this.currentNode.getSubject(), this.currentProperty, (org.eclipse.rdf4j.model.Value)nextNode, (Resource)this.context);
            this.next = Collections.singleton(connectNext);
            this.currentNode = null;
            this.currentContent = null;
            this.connector.addStatements(this.next);
        } else {
            this.next = Collections.emptyList();
        }
        this.connector.removeStatements(toRemove);
    }

    @Override
    public void replaceCurrentWith(T newContent) throws Rdf4jDriverException {
        assert (this.currentNode.getObject() instanceof Resource);
        this.connector.removeStatements(this.currentContent);
        Collection<org.eclipse.rdf4j.model.Value> contentValues = new ReferencedListHelper(this.valueConverter).toRdf4jValue(this.listDescriptor.getNodeContent(), newContent);
        Resource node = (Resource)this.currentNode.getObject();
        this.connector.addStatements(contentValues.stream().map(v -> this.vf.createStatement(node, this.hasContentProperty, v, (Resource)this.context)).collect(Collectors.toList()));
    }
}

