/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.list;

import cz.cvut.kbss.ontodriver.descriptor.ListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.SimpleListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.SimpleListValueDescriptor;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.list.ListHandler;
import cz.cvut.kbss.ontodriver.rdf4j.list.ListIterator;
import cz.cvut.kbss.ontodriver.rdf4j.list.SimpleListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;

public class SimpleListHandler
extends ListHandler<SimpleListValueDescriptor> {
    public SimpleListHandler(RepoConnection connector, ValueFactory vf) {
        super(connector, vf);
    }

    public List<Axiom<NamedResource>> loadList(SimpleListDescriptor listDescriptor) throws Rdf4jDriverException {
        ArrayList<Axiom<NamedResource>> axioms = new ArrayList<Axiom<NamedResource>>();
        SimpleListIterator it = new SimpleListIterator(listDescriptor, this.connector, this.vf);
        while (it.hasNext()) {
            axioms.add(it.nextAxiom());
        }
        return axioms;
    }

    @Override
    protected IRI createListHead(SimpleListValueDescriptor listValueDescriptor, Collection<Statement> listStatements) {
        IRI firstNode = this.toRdf4jIri(((NamedResource)listValueDescriptor.getValues().get(0)).getIdentifier());
        listStatements.add(this.vf.createStatement((Resource)this.owner((ListDescriptor)listValueDescriptor), this.hasList((ListDescriptor)listValueDescriptor), (Value)firstNode, (Resource)this.context((ListDescriptor)listValueDescriptor)));
        return firstNode;
    }

    @Override
    protected List<Statement> createListRest(IRI head, SimpleListValueDescriptor listValueDescriptor) {
        ArrayList<Statement> statements = new ArrayList<Statement>(listValueDescriptor.getValues().size());
        IRI previous = head;
        IRI nextNodeProp = this.hasNext((ListDescriptor)listValueDescriptor);
        IRI context = this.context((ListDescriptor)listValueDescriptor);
        Iterator it = listValueDescriptor.getValues().iterator();
        it.next();
        while (it.hasNext()) {
            IRI object = this.toRdf4jIri(((NamedResource)it.next()).getIdentifier());
            statements.add(this.vf.createStatement((Resource)previous, nextNodeProp, (Value)object, (Resource)context));
            previous = object;
        }
        return statements;
    }

    @Override
    protected void clearList(SimpleListValueDescriptor listValueDescriptor) throws Rdf4jDriverException {
        Collection<Statement> stmts;
        Set<IRI> contexts = this.contexts((ListDescriptor)listValueDescriptor);
        ArrayList<Statement> toRemove = new ArrayList<Statement>();
        IRI currentProperty = this.hasList((ListDescriptor)listValueDescriptor);
        IRI hasNext = this.hasNext((ListDescriptor)listValueDescriptor);
        boolean includeInferred = listValueDescriptor.getNextNode().isInferred();
        IRI subject = this.owner((ListDescriptor)listValueDescriptor);
        do {
            if (!(stmts = this.connector.findStatements((Resource)subject, currentProperty, null, includeInferred, contexts)).isEmpty()) {
                subject = this.extractListNode(stmts, hasNext);
                toRemove.addAll(stmts);
            }
            currentProperty = hasNext;
        } while (!stmts.isEmpty());
        this.connector.removeStatements(toRemove);
    }

    @Override
    protected void mergeList(SimpleListValueDescriptor listDescriptor) throws Rdf4jDriverException {
        ListIterator<NamedResource> it = this.iterator(listDescriptor);
        ListHandler.MergeResult mergeResult = this.mergeWithOriginalList(listDescriptor, it);
        this.removeObsoletes(it);
        assert (mergeResult.i > 0);
        assert (mergeResult.previous != null);
        if (mergeResult.i < listDescriptor.getValues().size()) {
            this.appendNewNodes(listDescriptor, mergeResult);
        }
    }

    ListHandler.MergeResult mergeWithOriginalList(SimpleListValueDescriptor listDescriptor, ListIterator<NamedResource> it) throws Rdf4jDriverException {
        int i;
        Resource node = null;
        for (i = 0; it.hasNext() && i < listDescriptor.getValues().size(); ++i) {
            node = it.nextNode();
            NamedResource newNode = (NamedResource)listDescriptor.getValues().get(i);
            if (node.stringValue().equals(newNode.getIdentifier().toString())) continue;
            node = this.toRdf4jIri(newNode.getIdentifier());
            it.replaceCurrentWith(newNode);
        }
        return new ListHandler.MergeResult(i, node);
    }

    void appendNewNodes(SimpleListValueDescriptor listDescriptor, ListHandler.MergeResult mergeResult) throws Rdf4jDriverException {
        int i;
        ArrayList<Statement> toAdd = new ArrayList<Statement>(listDescriptor.getValues().size() - i);
        Resource previous = mergeResult.previous;
        IRI nextNode = this.toRdf4jIri(listDescriptor.getNextNode().getIdentifier());
        IRI context = this.context((ListDescriptor)listDescriptor);
        for (i = mergeResult.i; i < listDescriptor.getValues().size(); ++i) {
            IRI newNode = this.toRdf4jIri(((NamedResource)listDescriptor.getValues().get(i)).getIdentifier());
            Statement stmt = this.vf.createStatement(previous, nextNode, (Value)newNode, (Resource)context);
            toAdd.add(stmt);
            previous = newNode;
        }
        this.connector.addStatements(toAdd);
    }

    private ListIterator<NamedResource> iterator(SimpleListValueDescriptor listDescriptor) throws Rdf4jDriverException {
        return new SimpleListIterator((SimpleListDescriptor)listDescriptor, this.connector, this.vf);
    }
}

