/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.list;

import cz.cvut.kbss.ontodriver.descriptor.ListDescriptor;
import cz.cvut.kbss.ontodriver.descriptor.SimpleListDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.model.AxiomImpl;
import cz.cvut.kbss.ontodriver.model.NamedResource;
import cz.cvut.kbss.ontodriver.model.Value;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.list.AbstractListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;

class SimpleListIterator
extends AbstractListIterator<NamedResource> {
    private final SimpleListDescriptor listDescriptor;
    private IRI currentProperty;
    private Statement current;
    private Collection<Statement> next;

    public SimpleListIterator(SimpleListDescriptor listDescriptor, RepoConnection connector, ValueFactory vf) throws Rdf4jDriverException {
        super((ListDescriptor)listDescriptor, connector, vf);
        this.listDescriptor = listDescriptor;
        this.currentProperty = this.hasListProperty;
        this.init();
    }

    private void init() throws Rdf4jDriverException {
        this.next = this.connector.findStatements(this.listOwner, this.hasListProperty, null, this.includeInferred, this.contexts());
    }

    @Override
    public boolean hasNext() {
        return !this.next.isEmpty();
    }

    @Override
    public Resource nextNode() throws Rdf4jDriverException {
        this.nextInternal();
        assert (this.current.getObject().isResource());
        return (Resource)this.current.getObject();
    }

    private void nextInternal() throws Rdf4jDriverException {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        this.checkSuccessorMax(this.next, this.currentProperty);
        this.current = this.next.iterator().next();
        this.currentProperty = this.current.getPredicate();
        this.checkObjectIsResource(this.current);
        Resource elem = (Resource)this.current.getObject();
        this.next = this.connector.findStatements(elem, this.hasNextProperty, null, this.includeInferred, this.contexts());
    }

    @Override
    public NamedResource currentContent() {
        assert (this.current.getObject().isResource());
        return NamedResource.create((String)this.current.getObject().stringValue());
    }

    @Override
    public Axiom<NamedResource> nextAxiom() throws Rdf4jDriverException {
        this.nextInternal();
        assert (this.current.getObject().isResource());
        Assertion assertion = this.current.getPredicate() == this.hasListProperty ? this.listDescriptor.getListProperty() : this.listDescriptor.getNextNode();
        return SimpleListIterator.createAxiom(this.current.getSubject(), assertion, (Resource)this.current.getObject());
    }

    private static Axiom<NamedResource> createAxiom(Resource subject, Assertion assertion, Resource value) {
        return new AxiomImpl(NamedResource.create((String)subject.stringValue()), assertion, new Value((Object)NamedResource.create((String)value.stringValue())));
    }

    @Override
    public void replaceCurrentWith(NamedResource newNode) throws Rdf4jDriverException {
        assert (this.current.getObject() instanceof Resource);
        IRI newNodeRdf4j = this.vf.createIRI(newNode.getIdentifier().toString());
        ArrayList<Statement> toAdd = new ArrayList<Statement>(2);
        ArrayList<Statement> toRemove = new ArrayList<Statement>(2);
        toRemove.add(this.current);
        Statement newCurrent = this.vf.createStatement(this.current.getSubject(), this.currentProperty, (org.eclipse.rdf4j.model.Value)newNodeRdf4j, (Resource)this.context);
        toAdd.add(newCurrent);
        if (this.hasNext()) {
            toRemove.addAll(this.next);
            Statement stmt = this.next.iterator().next();
            this.checkObjectIsResource(stmt);
            Resource nextNode = (Resource)stmt.getObject();
            if (!newNodeRdf4j.equals(nextNode)) {
                Statement newNext = this.vf.createStatement((Resource)newNodeRdf4j, this.hasNextProperty, (org.eclipse.rdf4j.model.Value)nextNode, (Resource)this.context);
                toAdd.add(newNext);
                this.next = Collections.singletonList(newNext);
            } else {
                this.next = this.connector.findStatements((Resource)newNodeRdf4j, this.hasNextProperty, null, this.includeInferred, this.contexts());
            }
        } else {
            this.next = Collections.emptyList();
        }
        this.current = null;
        this.connector.removeStatements(toRemove);
        this.connector.addStatements(toAdd);
    }

    @Override
    public void remove() throws Rdf4jDriverException {
        assert (this.current.getObject().isResource());
        ArrayList<Statement> toRemove = new ArrayList<Statement>(this.next.size() + 1);
        toRemove.add(this.current);
        if (this.hasNext()) {
            toRemove.addAll(this.next);
            Statement stmt = this.next.iterator().next();
            this.checkObjectIsResource(stmt);
            Resource nextNode = (Resource)stmt.getObject();
            Statement toAdd = this.vf.createStatement(this.current.getSubject(), this.currentProperty, (org.eclipse.rdf4j.model.Value)nextNode, (Resource)this.context);
            this.next = Collections.singletonList(toAdd);
            this.current = null;
            this.connector.addStatements(this.next);
        } else {
            this.next = Collections.emptyList();
        }
        this.connector.removeStatements(toRemove);
    }
}

