/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.loader;

import cz.cvut.kbss.ontodriver.descriptor.AxiomDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.loader.StatementLoader;
import cz.cvut.kbss.ontodriver.rdf4j.util.AxiomBuilder;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;

public class GraphDBStatementLoader
extends StatementLoader {
    static final URI GRAPHDB_IMPLICIT_CONTEXT = URI.create("http://www.ontotext.com/implicit");
    static final URI GRAPHDB_EXPLICIT_CONTEXT = URI.create("http://www.ontotext.com/explicit");

    public GraphDBStatementLoader(RepoConnection connector, Resource subject, AxiomBuilder axiomBuilder) {
        super(connector, subject, axiomBuilder);
    }

    @Override
    protected Set<URI> resolveContexts(AxiomDescriptor descriptor, Assertion a) {
        HashSet<URI> contexts = new HashSet<URI>(super.resolveContexts(descriptor, a));
        if (this.includeInferred) {
            contexts.add(GRAPHDB_IMPLICIT_CONTEXT);
            contexts.add(GRAPHDB_EXPLICIT_CONTEXT);
        }
        return contexts;
    }

    @Override
    protected boolean contextMatches(Set<URI> assertionCtx, Statement s, Assertion a) {
        if (this.includeInferred && a.isInferred() && s.getContext() == null) {
            return true;
        }
        return super.contextMatches(assertionCtx, s, a);
    }

    @Override
    public Collection<Axiom<?>> loadAxioms(Set<URI> contexts) throws Rdf4jDriverException {
        if (this.includeInferred) {
            HashSet<URI> contextsToUse = new HashSet<URI>(contexts);
            contextsToUse.add(GRAPHDB_IMPLICIT_CONTEXT);
            contextsToUse.add(GRAPHDB_EXPLICIT_CONTEXT);
            return super.loadAxioms(contextsToUse);
        }
        return super.loadAxioms(contexts);
    }
}

