/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.loader;

import cz.cvut.kbss.ontodriver.descriptor.AxiomDescriptor;
import cz.cvut.kbss.ontodriver.model.Assertion;
import cz.cvut.kbss.ontodriver.model.Axiom;
import cz.cvut.kbss.ontodriver.rdf4j.connector.RepoConnection;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.util.AxiomBuilder;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;

public class StatementLoader {
    private final RepoConnection connector;
    private final Resource subject;
    private final ValueFactory vf;
    private final AxiomBuilder axiomBuilder;
    private int loadAllThreshold = 5;
    private boolean loadAll;
    boolean includeInferred;

    public StatementLoader(RepoConnection connector, Resource subject, AxiomBuilder axiomBuilder) {
        this.connector = connector;
        this.vf = connector.getValueFactory();
        this.subject = subject;
        this.axiomBuilder = axiomBuilder;
    }

    public void setLoadAllThreshold(int loadAllThreshold) {
        this.loadAllThreshold = loadAllThreshold;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public Collection<Axiom<?>> loadAxioms(AxiomDescriptor descriptor, Map<IRI, Assertion> properties) throws Rdf4jDriverException {
        this.loadAll = properties.containsValue(Assertion.createUnspecifiedPropertyAssertion((boolean)this.includeInferred));
        if (properties.size() < this.loadAllThreshold && !this.loadAll) {
            return this.loadOneByOne(descriptor, properties);
        }
        return this.loadAll(descriptor, properties);
    }

    private Collection<Axiom<?>> loadOneByOne(AxiomDescriptor descriptor, Map<IRI, Assertion> assertions) throws Rdf4jDriverException {
        HashSet result = new HashSet();
        for (Map.Entry<IRI, Assertion> e : assertions.entrySet()) {
            Set<IRI> contexts = this.resolveContexts(descriptor, e.getValue()).stream().map(uri -> Rdf4jUtils.toRdf4jIri(uri, this.vf)).collect(Collectors.toSet());
            Collection<Statement> statements = this.connector.findStatements(this.subject, e.getKey(), null, this.includeInferred, contexts);
            for (Statement s : statements) {
                Axiom<?> axiom = this.axiomBuilder.statementToAxiom(s, e.getValue());
                if (axiom == null) continue;
                result.add(axiom);
            }
        }
        return result;
    }

    protected Set<URI> resolveContexts(AxiomDescriptor descriptor, Assertion a) {
        return descriptor.getAssertionContexts(a);
    }

    private Collection<Axiom<?>> loadAll(AxiomDescriptor descriptor, Map<IRI, Assertion> properties) throws Rdf4jDriverException {
        Collection<Statement> statements = this.connector.findStatements(this.subject, null, null, this.includeInferred);
        HashSet result = new HashSet(statements.size());
        Assertion unspecified = Assertion.createUnspecifiedPropertyAssertion((boolean)this.includeInferred);
        for (Statement s : statements) {
            Axiom<?> axiom;
            Assertion a;
            if (!properties.containsKey(s.getPredicate()) && !this.loadAll || !this.contextMatches(descriptor.getAssertionContexts(a = this.getAssertion(properties, s)), s, a) && (!this.loadAll || !this.contextMatches(descriptor.getAssertionContexts(unspecified), s, a)) || (axiom = this.axiomBuilder.statementToAxiom(s)) == null) continue;
            result.add(axiom);
        }
        return result;
    }

    private Assertion getAssertion(Map<IRI, Assertion> properties, Statement s) {
        if (properties.containsKey(s.getPredicate())) {
            return properties.get(s.getPredicate());
        }
        return Assertion.createUnspecifiedPropertyAssertion((boolean)this.includeInferred);
    }

    protected boolean contextMatches(Set<URI> assertionCtx, Statement s, Assertion a) {
        if (assertionCtx.isEmpty()) {
            return true;
        }
        Resource statementContext = s.getContext();
        return statementContext != null && assertionCtx.contains(URI.create(statementContext.stringValue()));
    }

    public Collection<Axiom<?>> loadAxioms(Set<URI> contexts) throws Rdf4jDriverException {
        Collection<Statement> statements = this.connector.findStatements(this.subject, null, null, this.includeInferred, contexts.stream().map(uri -> Rdf4jUtils.toRdf4jIri(uri, this.vf)).collect(Collectors.toSet()));
        return statements.stream().map(this.axiomBuilder::statementToAxiom).collect(Collectors.toSet());
    }
}

