/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.query;

import cz.cvut.kbss.ontodriver.ResultSet;
import cz.cvut.kbss.ontodriver.Statement;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import java.util.NoSuchElementException;

abstract class AbstractResultSet
implements ResultSet {
    private final Statement statement;
    private int index;
    private boolean open;

    AbstractResultSet(Statement statement) {
        assert (statement != null);
        this.statement = statement;
        this.index = -1;
        this.open = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getRowIndex() {
        this.ensureOpen();
        return this.index;
    }

    public Statement getStatement() {
        this.ensureOpen();
        return this.statement;
    }

    public boolean isFirst() {
        this.ensureOpen();
        return this.index == 0;
    }

    void ensureOpen() {
        if (!this.open) {
            throw new IllegalStateException("The result set is closed!");
        }
    }

    public void close() throws OntoDriverException {
        this.open = false;
    }

    public void first() {
        throw new UnsupportedOperationException("Returning to the first row is not supported by this result set.");
    }

    public void previous() {
        throw new UnsupportedOperationException("Going back is not supported by this result set.");
    }

    public void relative(int rows) throws OntoDriverException {
        this.setRowIndex(this.index + rows);
    }

    public void last() throws OntoDriverException {
        this.ensureOpen();
        while (this.hasNext()) {
            this.next();
        }
    }

    public void next() throws OntoDriverException {
        this.ensureOpen();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void setRowIndex(int rowIndex) throws OntoDriverException {
        this.ensureOpen();
        if (rowIndex < this.index) {
            throw new UnsupportedOperationException("Going back in this result set is not supported.");
        }
        if (rowIndex == this.index) {
            return;
        }
        while (this.index <= rowIndex) {
            this.next();
        }
    }
}

