/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.query;

import cz.cvut.kbss.ontodriver.Statement;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.query.AbstractResultSet;

public class AskResultSet
extends AbstractResultSet {
    private final boolean result;

    public AskResultSet(boolean result, Statement statement) {
        super(statement);
        this.result = result;
    }

    public int findColumn(String columnLabel) {
        return 0;
    }

    public int getColumnCount() {
        return 1;
    }

    public boolean isBound(int variableIndex) {
        return true;
    }

    public boolean isBound(String variableName) {
        return true;
    }

    public boolean getBoolean(int columnIndex) {
        this.ensureState();
        return this.result;
    }

    private void ensureState() {
        this.ensureOpen();
        if (!this.isFirst()) {
            throw new IllegalStateException("Must call next before getting the first value.");
        }
    }

    public boolean getBoolean(String columnLabel) {
        this.ensureState();
        return this.result;
    }

    public byte getByte(int columnIndex) {
        this.ensureState();
        throw AskResultSet.unsupported("byte");
    }

    private static UnsupportedOperationException unsupported(String type) {
        return new UnsupportedOperationException("ASK query results cannot return " + type + "values.");
    }

    public byte getByte(String columnLabel) {
        this.ensureState();
        throw AskResultSet.unsupported("byte");
    }

    public double getDouble(int columnIndex) {
        this.ensureState();
        throw AskResultSet.unsupported("double");
    }

    public double getDouble(String columnLabel) {
        this.ensureState();
        throw AskResultSet.unsupported("double");
    }

    public float getFloat(int columnIndex) {
        this.ensureState();
        throw AskResultSet.unsupported("float");
    }

    public float getFloat(String columnLabel) {
        this.ensureState();
        throw AskResultSet.unsupported("float");
    }

    public int getInt(int columnIndex) {
        this.ensureState();
        throw AskResultSet.unsupported("int");
    }

    public int getInt(String columnLabel) {
        this.ensureState();
        throw AskResultSet.unsupported("int");
    }

    public long getLong(int columnIndex) {
        this.ensureState();
        throw AskResultSet.unsupported("long");
    }

    public long getLong(String columnLabel) {
        this.ensureState();
        throw AskResultSet.unsupported("long");
    }

    public Object getObject(int columnIndex) {
        this.ensureState();
        return this.result;
    }

    public Object getObject(String columnLabel) {
        this.ensureState();
        return this.result;
    }

    public <T> T getObject(int columnIndex, Class<T> cls) throws OntoDriverException {
        this.ensureState();
        return this.toType(cls);
    }

    public <T> T getObject(String columnLabel, Class<T> cls) throws OntoDriverException {
        this.ensureState();
        return this.toType(cls);
    }

    private <T> T toType(Class<T> type) throws Rdf4jDriverException {
        if (type.isAssignableFrom(Boolean.class)) {
            return type.cast(this.result);
        }
        if (type.isAssignableFrom(String.class)) {
            return type.cast(this.getString(0));
        }
        throw new Rdf4jDriverException("Unable to return boolean result as type " + String.valueOf(type));
    }

    public short getShort(int columnIndex) {
        this.ensureState();
        throw AskResultSet.unsupported("short");
    }

    public short getShort(String columnLabel) {
        this.ensureState();
        throw AskResultSet.unsupported("short");
    }

    public String getString(int columnIndex) {
        this.ensureState();
        return Boolean.toString(this.result);
    }

    public String getString(String columnLabel) {
        this.ensureState();
        return Boolean.toString(this.result);
    }

    public boolean hasNext() throws OntoDriverException {
        this.ensureOpen();
        return !this.isFirst();
    }
}

