/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.query;

import cz.cvut.kbss.ontodriver.PreparedStatement;
import cz.cvut.kbss.ontodriver.ResultSet;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.connector.StatementExecutor;
import cz.cvut.kbss.ontodriver.rdf4j.query.Rdf4jStatement;
import cz.cvut.kbss.ontodriver.util.StatementHolder;
import java.util.Objects;

public class Rdf4jPreparedStatement
extends Rdf4jStatement
implements PreparedStatement {
    private final StatementHolder statementHolder;

    public Rdf4jPreparedStatement(StatementExecutor executor, String statement) {
        super(executor);
        this.statementHolder = new StatementHolder(statement);
        if (this.statementHolder.getStatement().isEmpty()) {
            throw new IllegalArgumentException("The statement string cannot be empty.");
        }
        this.statementHolder.analyzeStatement();
    }

    public void setObject(String binding, Object value) {
        this.ensureOpen();
        Objects.requireNonNull(value);
        this.statementHolder.setParameter(binding, value.toString());
    }

    public ResultSet executeQuery() throws OntoDriverException {
        this.ensureOpen();
        return this.executeQuery(this.statementHolder.assembleStatement());
    }

    public void executeUpdate() throws OntoDriverException {
        this.ensureOpen();
        this.executeUpdate(this.statementHolder.assembleStatement());
    }

    public void clearParameters() {
        this.statementHolder.clearParameters();
    }
}

