/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.query;

import cz.cvut.kbss.ontodriver.ResultSet;
import cz.cvut.kbss.ontodriver.Statement;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.connector.StatementExecutor;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.query.AskResultSet;
import cz.cvut.kbss.ontodriver.rdf4j.query.QuerySpecification;
import cz.cvut.kbss.ontodriver.rdf4j.query.SelectResultSet;
import java.util.Objects;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rdf4jStatement
implements Statement {
    private static final Logger LOG = LoggerFactory.getLogger(Rdf4jStatement.class);
    private boolean inferenceDisabled = false;
    private final StatementExecutor queryExecutor;
    private ResultSet resultSet;
    private boolean open;

    public Rdf4jStatement(StatementExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
        this.open = true;
    }

    public ResultSet executeQuery(String sparql) throws OntoDriverException {
        this.ensureOpen();
        Rdf4jStatement.validateQueryParams(sparql);
        this.closeCurrentResultSet();
        this.resultSet = this.determineResult(sparql);
        return this.resultSet;
    }

    private ResultSet determineResult(String sparql) throws Rdf4jDriverException {
        if (Rdf4jStatement.isAskQuery(sparql)) {
            return new AskResultSet(this.queryExecutor.executeBooleanQuery(this.querySpec(sparql)), this);
        }
        TupleQueryResult tqr = this.queryExecutor.executeSelectQuery(this.querySpec(sparql));
        try {
            return new SelectResultSet(tqr, this);
        }
        catch (QueryEvaluationException e) {
            throw new Rdf4jDriverException(e);
        }
    }

    QuerySpecification querySpec(String sparql) {
        return QuerySpecification.query(sparql).includeInference(!this.inferenceDisabled);
    }

    private static boolean isAskQuery(String query) throws Rdf4jDriverException {
        try {
            return QueryParserUtil.parseOperation((QueryLanguage)QueryLanguage.SPARQL, (String)query, null) instanceof ParsedBooleanQuery;
        }
        catch (MalformedQueryException e) {
            throw new Rdf4jDriverException("Invalid query \"" + query + "\".", e);
        }
    }

    public void executeUpdate(String sparql) throws OntoDriverException {
        this.ensureOpen();
        Rdf4jStatement.validateQueryParams(sparql);
        this.closeCurrentResultSet();
        this.queryExecutor.executeUpdate(this.querySpec(sparql));
    }

    public void useOntology(Statement.StatementOntology ontology) {
        LOG.warn("RDF4J driver does not support changing the target ontology because it does not use transactional data snapshots.");
    }

    public Statement.StatementOntology getStatementOntology() {
        return Statement.StatementOntology.SHARED;
    }

    private static void validateQueryParams(String sparql) {
        Objects.requireNonNull(sparql);
        if (sparql.isEmpty()) {
            throw new IllegalArgumentException("Query string cannot be empty.");
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() throws OntoDriverException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.closeCurrentResultSet();
    }

    private void closeCurrentResultSet() throws OntoDriverException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    public void disableInference() {
        this.inferenceDisabled = true;
    }

    public boolean isInferenceDisabled() {
        return this.inferenceDisabled;
    }

    void ensureOpen() {
        if (!this.open) {
            throw new IllegalStateException("This statement is closed.");
        }
    }
}

