/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.kbss.ontodriver.rdf4j.query;

import cz.cvut.kbss.jopa.datatype.DatatypeTransformer;
import cz.cvut.kbss.jopa.datatype.exception.UnsupportedTypeTransformationException;
import cz.cvut.kbss.ontodriver.Statement;
import cz.cvut.kbss.ontodriver.exception.OntoDriverException;
import cz.cvut.kbss.ontodriver.exception.VariableNotBoundException;
import cz.cvut.kbss.ontodriver.rdf4j.exception.Rdf4jDriverException;
import cz.cvut.kbss.ontodriver.rdf4j.query.AbstractResultSet;
import cz.cvut.kbss.ontodriver.rdf4j.util.Rdf4jUtils;
import java.util.List;
import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;

public class SelectResultSet
extends AbstractResultSet {
    private final TupleQueryResult result;
    private List<String> bindings;
    private BindingSet current;

    public SelectResultSet(TupleQueryResult result, Statement statement) {
        super(statement);
        assert (result != null);
        this.result = result;
        this.init();
    }

    private void init() {
        this.bindings = this.result.getBindingNames();
    }

    @Override
    public void close() throws OntoDriverException {
        try {
            this.result.close();
        }
        catch (QueryEvaluationException e) {
            throw new OntoDriverException((Throwable)e);
        }
        finally {
            super.close();
        }
    }

    public int findColumn(String columnLabel) {
        this.ensureOpen();
        return this.bindings.indexOf(columnLabel);
    }

    public int getColumnCount() {
        this.ensureOpen();
        return this.bindings.size();
    }

    public boolean isBound(int variableIndex) {
        return variableIndex >= 0 && variableIndex < this.bindings.size() && this.current.getValue(this.bindings.get(variableIndex)) != null;
    }

    public boolean isBound(String variableName) {
        Objects.requireNonNull(variableName);
        return this.bindings.contains(variableName) && this.current.getValue(variableName) != null;
    }

    public boolean getBoolean(int columnIndex) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toBoolean(this.getLiteralValue(columnIndex));
    }

    public boolean getBoolean(String columnLabel) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toBoolean(this.getLiteralValue(columnLabel));
    }

    private static boolean toBoolean(Object ob) {
        if (ob instanceof Boolean) {
            return (Boolean)ob;
        }
        return Boolean.parseBoolean(ob.toString());
    }

    public byte getByte(int columnIndex) throws OntoDriverException {
        this.ensureOpen();
        return (byte)SelectResultSet.toInt(this.getLiteralValue(columnIndex));
    }

    public byte getByte(String columnLabel) throws OntoDriverException {
        this.ensureOpen();
        return (byte)SelectResultSet.toInt(this.getLiteralValue(columnLabel));
    }

    public double getDouble(int columnIndex) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toDouble(this.getLiteralValue(columnIndex));
    }

    public double getDouble(String columnLabel) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toDouble(this.getLiteralValue(columnLabel));
    }

    private static double toDouble(Object ob) throws OntoDriverException {
        if (ob instanceof Number) {
            return ((Number)ob).doubleValue();
        }
        try {
            return Double.parseDouble(ob.toString());
        }
        catch (NumberFormatException e) {
            throw new OntoDriverException((Throwable)e);
        }
    }

    public float getFloat(int columnIndex) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toFloat(this.getLiteralValue(columnIndex));
    }

    public float getFloat(String columnLabel) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toFloat(this.getLiteralValue(columnLabel));
    }

    private static float toFloat(Object ob) throws OntoDriverException {
        if (ob instanceof Number) {
            return ((Number)ob).floatValue();
        }
        try {
            return Float.parseFloat(ob.toString());
        }
        catch (NumberFormatException e) {
            throw new OntoDriverException((Throwable)e);
        }
    }

    public int getInt(int columnIndex) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toInt(this.getLiteralValue(columnIndex));
    }

    public int getInt(String columnLabel) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toInt(this.getLiteralValue(columnLabel));
    }

    private static int toInt(Object ob) throws OntoDriverException {
        if (ob instanceof Number) {
            return ((Number)ob).intValue();
        }
        try {
            return Integer.parseInt(ob.toString());
        }
        catch (NumberFormatException e) {
            throw new OntoDriverException((Throwable)e);
        }
    }

    public long getLong(int columnIndex) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toLong(this.getLiteralValue(columnIndex));
    }

    public long getLong(String columnLabel) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toLong(this.getLiteralValue(columnLabel));
    }

    private static long toLong(Object ob) throws OntoDriverException {
        if (ob instanceof Number) {
            return ((Number)ob).longValue();
        }
        try {
            return Long.parseLong(ob.toString());
        }
        catch (NumberFormatException e) {
            throw new OntoDriverException((Throwable)e);
        }
    }

    public Object getObject(int columnIndex) {
        this.ensureOpen();
        return SelectResultSet.toObject(this.getCurrent(columnIndex));
    }

    public Object getObject(String columnLabel) {
        this.ensureOpen();
        return SelectResultSet.toObject(this.getCurrent(columnLabel));
    }

    private static Object toObject(Value val) {
        assert (val != null);
        if (val instanceof Literal) {
            return Rdf4jUtils.getLiteralValue((Literal)val);
        }
        if (val instanceof IRI) {
            return Rdf4jUtils.toJavaUri((Resource)((IRI)val));
        }
        return val.toString();
    }

    public <T> T getObject(int columnIndex, Class<T> cls) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toObject(this.getCurrent(columnIndex), cls);
    }

    public <T> T getObject(String columnLabel, Class<T> cls) throws OntoDriverException {
        this.ensureOpen();
        return SelectResultSet.toObject(this.getCurrent(columnLabel), cls);
    }

    private static <T> T toObject(Value val, Class<T> cls) throws OntoDriverException {
        assert (val != null);
        if (cls.isAssignableFrom(val.getClass())) {
            return cls.cast(val);
        }
        Object ob = null;
        if (val instanceof Literal) {
            ob = Rdf4jUtils.getLiteralValue((Literal)val);
        } else if (val instanceof IRI) {
            ob = Rdf4jUtils.toJavaUri((Resource)((IRI)val));
        }
        try {
            return cls.cast(DatatypeTransformer.transform((Object)ob, cls));
        }
        catch (UnsupportedTypeTransformationException e) {
            throw new Rdf4jDriverException("Unable to transform value to target object.", e);
        }
    }

    public short getShort(int columnIndex) throws OntoDriverException {
        this.ensureOpen();
        return (short)SelectResultSet.toInt(this.getLiteralValue(columnIndex));
    }

    public short getShort(String columnLabel) throws OntoDriverException {
        this.ensureOpen();
        return (short)SelectResultSet.toInt(this.getLiteralValue(columnLabel));
    }

    public String getString(int columnIndex) {
        this.ensureOpen();
        return SelectResultSet.getStringImpl(this.getCurrent(columnIndex));
    }

    public String getString(String columnLabel) {
        this.ensureOpen();
        return SelectResultSet.getStringImpl(this.getCurrent(columnLabel));
    }

    private static String getStringImpl(Value val) {
        if (val instanceof Literal) {
            return Rdf4jUtils.getLiteralValue((Literal)val).toString();
        }
        return val.toString();
    }

    public boolean hasNext() throws OntoDriverException {
        this.ensureOpen();
        try {
            return this.result.hasNext();
        }
        catch (QueryEvaluationException e) {
            throw new OntoDriverException((Throwable)e);
        }
    }

    @Override
    public void next() throws OntoDriverException {
        super.next();
        try {
            this.current = (BindingSet)this.result.next();
        }
        catch (QueryEvaluationException e) {
            throw new OntoDriverException((Throwable)e);
        }
    }

    private Object getLiteralValue(int columnIndex) throws OntoDriverException {
        Value val = this.getCurrent(columnIndex);
        if (!(val instanceof Literal)) {
            throw new OntoDriverException("Expected value " + String.valueOf(val) + " to be a literal.");
        }
        return Rdf4jUtils.getLiteralValue((Literal)val);
    }

    private Object getLiteralValue(String columnName) throws OntoDriverException {
        Value val = this.getCurrent(columnName);
        if (!(val instanceof Literal)) {
            throw new OntoDriverException("Expected value " + String.valueOf(val) + " to be a literal.");
        }
        return Rdf4jUtils.getLiteralValue((Literal)val);
    }

    private Value getCurrent(int columnIndex) {
        this.ensureState();
        if (columnIndex < 0 || columnIndex >= this.bindings.size()) {
            throw new IllegalArgumentException("The column index is out of bounds of the column count.");
        }
        Value v = this.current.getValue(this.bindings.get(columnIndex));
        if (v == null) {
            throw new VariableNotBoundException("Variable at index " + columnIndex + " is not bound in the current result row.");
        }
        return v;
    }

    private void ensureState() {
        if (this.current == null) {
            throw new IllegalStateException("Must call next before getting the first value.");
        }
    }

    private Value getCurrent(String columnName) {
        this.ensureState();
        if (!this.bindings.contains(columnName)) {
            throw new IllegalArgumentException("Unknown column name " + columnName);
        }
        Value v = this.current.getValue(columnName);
        if (v == null) {
            throw new VariableNotBoundException("Variable \"" + columnName + "\" is not bound in the current result row.");
        }
        return v;
    }
}

